import React, { ReactNode } from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { FilterGroup } from './filter-group.component';

describe('FilterGroup', () => {
    let wrapper: ReactWrapper;
    const mount = (title: string, children: ReactNode) => {
        wrapper = mountWithTheme(<FilterGroup title={title}>{children}</FilterGroup>);
    };
    const getTitle = () => wrapper.find(DotTypography);

    it('should render title and children', () => {
        mount('my title', <h2>my children</h2>);
        const title = getTitle();
        expect(title.text()).toBe('my title');
        expect(title.props().variant).toBe('overline');
        expect(wrapper.find('h2').text()).toBe('my children');
    });
});
