import React from 'react';
import { Provider } from 'react-redux';
import { store } from '../../../store/environment-management-store';
import { EnvironmentListComponent } from './environment-list-component';

export const EnvironmentListPage: React.FC<{ folderId: string }> = ({ folderId }) => {
    return (
        <Provider store={store}>
            <EnvironmentListComponent folderId={folderId} />
        </Provider>
    );
};
