/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository.persistence;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RemoveByReleaseUid;
import com.xebialabs.xlrelease.repository.RemoveByTemplateUid;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceConstants$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TemplateTriggerRow;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerMapper;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerQueryBuilder;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import com.xebialabs.xlrelease.utils.TenantContext$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.SqlBinaryValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tEh\u0001\u0002\u001d:\u0001\u0019C\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005O\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0007\u0011\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0007\t\u0019\u0001\u0003\u0006\u00024\u0001\u0011\t\u0011)A\u0005\u0003\u000bAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002R!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\n\u0003;\u0004!\u0019!C\u0005\u0003wB\u0001\"a8\u0001A\u0003%\u0011\u0011\u000b\u0005\b\u0003C\u0004A\u0011AAr\u0011%\tI\u000f\u0001b\u0001\n\u0013\tY\b\u0003\u0005\u0002l\u0002\u0001\u000b\u0011BA)\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!!?\u0001\t\u0013\tY\u0010C\u0004\u0003\f\u0001!IA!\u0004\t\u0013\tE\u0001A1A\u0005\n\u0005m\u0004\u0002\u0003B\n\u0001\u0001\u0006I!!\u0015\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018!I!1\u0004\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0005;\u0001\u0001\u0015!\u0003\u0002R!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002\"\u0003B\u001c\u0001\t\u0007I\u0011BA>\u0011!\u0011I\u0004\u0001Q\u0001\n\u0005E\u0003\"\u0003B\u001e\u0001\t\u0007I\u0011\u0002B\u001f\u0011!\u0011Y\u0005\u0001Q\u0001\n\t}\u0002b\u0002B'\u0001\u0011\u0005!q\n\u0005\n\u0005_\u0002!\u0019!C\u0005\u0003wB\u0001B!\u001d\u0001A\u0003%\u0011\u0011\u000b\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011%\u0011Y\b\u0001b\u0001\n\u0013\u0011i\b\u0003\u0005\u0003\u000e\u0002\u0001\u000b\u0011\u0002B@\u0011\u001d\u0011y\t\u0001C\u0001\u0005#C\u0011Ba&\u0001\u0005\u0004%I!a\u001f\t\u0011\te\u0005\u0001)A\u0005\u0003#BqAa'\u0001\t\u0003\u0011i\nC\u0005\u0003(\u0002\u0011\r\u0011\"\u0003\u0002|!A!\u0011\u0016\u0001!\u0002\u0013\t\t\u0006C\u0005\u0003,\u0002\u0011\r\u0011\"\u0003\u0002|!A!Q\u0016\u0001!\u0002\u0013\t\t\u0006C\u0004\u00030\u0002!\tA!-\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"I!Q\u001a\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0005\u001f\u0004\u0001\u0015!\u0003\u0002R!9!\u0011\u001b\u0001\u0005\u0002\tM\u0007\"\u0003Bl\u0001\t\u0007I\u0011BA>\u0011!\u0011I\u000e\u0001Q\u0001\n\u0005E\u0003b\u0002Bn\u0001\u0011\u0005!Q\u001c\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cWM\u0003\u0002;w\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\taT(\u0001\u0006sKB|7/\u001b;pefT!AP \u0002\u0011Q\u0014\u0018nZ4feNT!\u0001Q!\u0002\u0013ad'/\u001a7fCN,'B\u0001\"D\u0003%AXMY5bY\u0006\u00147OC\u0001E\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001q)\u0014+Z;B\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\u0004\"A\u0014*\u000e\u0003=S!\u0001U)\u0002\u0007M\fHN\u0003\u0002=\u007f%\u00111k\u0014\u0002\u000e'Fd'+\u001a9pg&$xN]=\u0011\u0005U;V\"\u0001,\u000b\u0005iz\u0015B\u0001-W\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0011\u0005i[V\"A\u001d\n\u0005qK$!\u0004+sS\u001e<WM]'baB,'\u000f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006)1\u000f\u001c45U*\t!-\u0001\u0005he&T(\u0010\\3e\u0013\t!wLA\u0004M_\u001e<\u0017N\\4\u0002#\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW-F\u0001h!\t)\u0006.\u0003\u0002j-\n\tbi\u001c7eKJ\u0004VM]:jgR,gnY3\u0002%\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0015gFd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u00035\u0004\"A\u00148\n\u0005=|%\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/A\u000btc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003M\u0004\"\u0001^?\u000e\u0003UT!A^<\u0002\t\r|'/\u001a\u0006\u0003qf\fAA\u001b3cG*\u0011!p_\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA0A\u0002pe\u001eL!A`;\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\"!!\u0002\u0011\t\u0005\u001d\u0011Q\u0006\b\u0005\u0003\u0013\t9C\u0004\u0003\u0002\f\u0005\rb\u0002BA\u0007\u0003?qA!a\u0004\u0002\u001e9!\u0011\u0011CA\u000e\u001d\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u000b\u00061AH]8pizJ\u0011\u0001R\u0005\u0003\u0005\u000eK!\u0001Q!\n\u0007\u0005\u0005r(\u0001\u0002eE&\u0019\u0001+!\n\u000b\u0007\u0005\u0005r(\u0003\u0003\u0002*\u0005-\u0012AC*rY\n+\u0018\u000e\u001c3fe*\u0019\u0001+!\n\n\t\u0005=\u0012\u0011\u0007\u0002\b\t&\fG.Z2u\u0015\u0011\tI#a\u000b\u0002\u0011\u0011L\u0017\r\\3di\u0002\na\u0001P5oSRtDCCA\u001d\u0003w\ti$a\u0010\u0002BA\u0011!\f\u0001\u0005\u0006K&\u0001\ra\u001a\u0005\u0006W&\u0001\r!\u001c\u0005\u0006c&\u0001\u001da\u001d\u0005\b\u0003\u0003I\u00019AA\u0003\u0003aqW/\u001c2fe>3G+Z7qY\u0006$X\r\u0016:jO\u001e,'o\u001d\u000b\u0005\u0003\u000f\ni\u0005E\u0002I\u0003\u0013J1!a\u0013J\u0005\rIe\u000e\u001e\u0005\b\u0003\u001fR\u0001\u0019AA)\u0003)!X-\u001c9mCR,\u0017\n\u001a\t\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005]\u0003cAA\n\u0013&\u0019\u0011\u0011L%\u0002\rA\u0013X\rZ3g\u0013\u0011\ti&a\u0018\u0003\rM#(/\u001b8h\u0015\r\tI&\u0013\u0015\u0004\u0015\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\t\u0005%\u00141F\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002n\u0005\u001d$AC%t%\u0016\fGm\u00148ms\u0006\u0019BO]5hO\u0016\u0014\u0018+^3ss\n+\u0018\u000e\u001c3feV\u0011\u00111\u000f\t\u00045\u0006U\u0014bAA<s\t\u0019BK]5hO\u0016\u0014\u0018+^3ss\n+\u0018\u000e\u001c3fe\u0006Y\u0012+V#S3~#&+S$H\u000bJ{&)W0U%&;u)\u0012*`\u0013\u0012+\"!!\u0015\u00029E+VIU-`)JKuiR#S?\nKv\f\u0016*J\u000f\u001e+%kX%EA\u0005Aa-\u001b8e\u0005fLE-\u0006\u0003\u0002\u0004\u0006=E\u0003BAC\u0003O\u0003R\u0001SAD\u0003\u0017K1!!#J\u0005\u0019y\u0005\u000f^5p]B!\u0011QRAH\u0019\u0001!q!!%\u000f\u0005\u0004\t\u0019JA\u0001U#\u0011\t)*a'\u0011\u0007!\u000b9*C\u0002\u0002\u001a&\u0013qAT8uQ&tw\r\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tkP\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0015\u0016q\u0014\u0002\b)JLwmZ3s\u0011\u001d\tIK\u0004a\u0001\u0003#\n\u0011\u0002\u001e:jO\u001e,'/\u00133\u0002\r\u0019Lg\u000e\u001a\"z)\u0019\ty+!0\u0002TB1\u0011\u0011WA]\u00037k!!a-\u000b\t\u0005\u0005\u0016Q\u0017\u0006\u0004\u0003oK\u0018\u0001\u00023bi\u0006LA!a/\u00024\n!\u0001+Y4f\u0011\u001d\tyl\u0004a\u0001\u0003\u0003\faAZ5mi\u0016\u0014\b\u0003BAb\u0003\u001fl!!!2\u000b\t\u0005}\u0016q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0002wc)\u0019\u0011QZ \u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002R\u0006\u0015'A\u0004+sS\u001e<WM\u001d$jYR,'o\u001d\u0005\b\u0003+|\u0001\u0019AAl\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BAY\u00033LA!a7\u00024\nA\u0001+Y4fC\ndW-A\nT)6#v,\u0013(T\u000bJ#v\f\u0016*J\u000f\u001e+%+\u0001\u000bT)6#v,\u0013(T\u000bJ#v\f\u0016*J\u000f\u001e+%\u000bI\u0001\u0007S:\u001cXM\u001d;\u0015\t\u0005m\u0015Q\u001d\u0005\b\u0003O\u0014\u0002\u0019AAN\u0003\u001d!(/[4hKJ\f1c\u0015+N)~+\u0006\u000bR!U\u000b~#&+S$H\u000bJ\u000bAc\u0015+N)~+\u0006\u000bR!U\u000b~#&+S$H\u000bJ\u0003\u0013AB;qI\u0006$X\r\u0006\u0003\u0002r\u0006]\bc\u0001%\u0002t&\u0019\u0011Q_%\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003O,\u0002\u0019AAN\u00031)\bo]3siB\u000b'/Y7t)\u0011\tiP!\u0003\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001v\u0003)q\u0017-\\3ea\u0006\u0014\u0018-\\\u0005\u0005\u0005\u000f\u0011\tAA\u000bNCB\u001c\u0016\u000f\u001c)be\u0006lW\r^3s'>,(oY3\t\u000f\u0005\u001dh\u00031\u0001\u0002\u001c\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003#\u0012y\u0001C\u0004\u0002h^\u0001\r!a'\u0002'M#V\nV0E\u000b2+E+R0U%&;u)\u0012*\u0002)M#V\nV0E\u000b2+E+R0U%&;u)\u0012*!\u0003\u0019!W\r\\3uKR!\u0011\u0011\u001fB\r\u0011\u001d\tIK\u0007a\u0001\u0003#\nAf\u0015+N)~;U\tV0F\u001d\u0006\u0013E*\u0012#`)JKuiR#S?&#5k\u0018$P%~#V)\u0014)M\u0003R+u,\u0013#\u0002[M#V\nV0H\u000bR{VIT!C\u0019\u0016#u\f\u0016*J\u000f\u001e+%kX%E'~3uJU0U\u000b6\u0003F*\u0011+F?&#\u0005%A\u000ehKR,e.\u00192mK\u0012\u0014V\r\\3bg\u0016$&/[4hKJLEm\u001d\u000b\u0005\u0005G\u0011)\u0004\u0005\u0004\u0003&\t=\u0012\u0011\u000b\b\u0005\u0005O\u0011YC\u0004\u0003\u0002\u0014\t%\u0012\"\u0001&\n\u0007\t5\u0012*A\u0004qC\u000e\\\u0017mZ3\n\t\tE\"1\u0007\u0002\u0004'\u0016\f(b\u0001B\u0017\u0013\"9\u0011qJ\u000fA\u0002\u0005E\u0013\u0001K*U\u001bR{v)\u0012+`)\u0016k\u0005\u000bT!U\u000b~#&+S$H\u000bJ{&kT,`\u0005f{&+\u0012'F\u0003N+\u0015!K*U\u001bR{v)\u0012+`)\u0016k\u0005\u000bT!U\u000b~#&+S$H\u000bJ{&kT,`\u0005f{&+\u0012'F\u0003N+\u0005%\u0001\ruK6\u0004H.\u0019;f)JLwmZ3s%><X*\u00199qKJ,\"Aa\u0010\u0011\u000bQ\u0014\tE!\u0012\n\u0007\t\rSOA\u0005S_^l\u0015\r\u001d9feB\u0019!La\u0012\n\u0007\t%\u0013H\u0001\nUK6\u0004H.\u0019;f)JLwmZ3s%><\u0018!\u0007;f[Bd\u0017\r^3Ue&<w-\u001a:S_^l\u0015\r\u001d9fe\u0002\nacZ3u)\u0016l\u0007\u000f\\1uKR\u0013\u0018nZ4feJ{wo\u001d\u000b\u0005\u0005#\u0012\u0019\u0006\u0005\u0004\u0003&\t=\"Q\t\u0005\b\u0005+\u0012\u0003\u0019\u0001B,\u00031\u0011X\r\\3bg\u0016\u001c\u0015.V5e!\u0011\u0011IF!\u001b\u000f\t\tm#q\r\b\u0005\u0005;\u0012)G\u0004\u0003\u0003`\t\rd\u0002BA\u0007\u0005CJ!\u0001P \n\u0005A\u000b\u0016B\u0001\u001eP\u0013\r\u0011iCV\u0005\u0005\u0005W\u0012iGA\u0003DSVKGMC\u0002\u0003.Y\u000b1$\u0013(T\u000bJ#v\fV#N!2\u000bE+R0U%&;u)\u0012*`%>;\u0016\u0001H%O'\u0016\u0013Fk\u0018+F\u001bBc\u0015\tV#`)JKuiR#S?J{u\u000bI\u0001\u0019S:\u001cXM\u001d;UK6\u0004H.\u0019;f)JLwmZ3s%><H\u0003BAy\u0005oBqA!\u001f&\u0001\u0004\u0011)%A\u0002s_^\f\u0011e\u0015+N)~;U\tV0U%&;u)\u0012*F\t~\u0013V\tT#B'\u0016\u001bvlQ(V\u001dR+\"Aa \u0011\t\t\u0005%1R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006!A.\u00198h\u0015\t\u0011I)\u0001\u0003kCZ\f\u0017\u0002BA/\u0005\u0007\u000b!e\u0015+N)~;U\tV0U%&;u)\u0012*F\t~\u0013V\tT#B'\u0016\u001bvlQ(V\u001dR\u0003\u0013\u0001I4fiJ+hN\\5oOR\u0013\u0018nZ4fe\u0016$'+\u001a7fCN,7oQ8v]R$B!a\u0012\u0003\u0014\"9!Q\u0013\u0015A\u0002\t]\u0013a\u0003;f[Bd\u0017\r^3VS\u0012\fA$\u0013(T\u000bJ#v\f\u0016*J\u000f\u001e+%+\u0012#`%\u0016cU)Q*F?J{u+A\u000fJ\u001dN+%\u000bV0U%&;u)\u0012*F\t~\u0013V\tT#B'\u0016{&kT,!\u0003eIgn]3siR\u0013\u0018nZ4fe\u0016$'+\u001a7fCN,'k\\<\u0015\t\u0005E(q\u0014\u0005\b\u0005sZ\u0003\u0019\u0001BQ!\rQ&1U\u0005\u0004\u0005KK$a\u0005+sS\u001e<WM]3e%\u0016dW-Y:f%><\u0018\u0001L*U\u001bR{F)\u0012'F)\u0016{FKU%H\u000f\u0016\u0013V\tR0S\u000b2+\u0015iU#`\u0005f{&+\u0012'F\u0003N+u,V%E\u00035\u001aF+\u0014+`\t\u0016cU\tV#`)JKuiR#S\u000b\u0012{&+\u0012'F\u0003N+uLQ-`%\u0016cU)Q*F?VKE\tI\u0001.'RkEk\u0018#F\u0019\u0016#Vi\u0018+S\u0013\u001e;UIU#E?J+E*R!T\u000b~\u0013\u0015l\u0018+F\u001bBc\u0015\tV#`+&#\u0015AL*U\u001bR{F)\u0012'F)\u0016{FKU%H\u000f\u0016\u0013V\tR0S\u000b2+\u0015iU#`\u0005f{F+R'Q\u0019\u0006#ViX+J\t\u0002\n!D]3n_Z,GK]5hO\u0016\u0014X\r\u001a*fY\u0016\f7/Z:S_^$B!!=\u00034\"9!Q\u0017\u0019A\u0002\t]\u0016!C2p]\u0012LG/[8o!\u0011\u0011ILa/\u000e\u0003EK1A!0R\u0005}\u0011V-\\8wKR\u0013\u0018nZ4fe\u0016$'+\u001a7fCN,7i\u001c8eSRLwN\\\u0001\u0012G\",7m\u001b#fY\u0016$XMU3tk2$H\u0003\u0002Bb\u0005\u0013\u0004r\u0001\u0013Bc\u0003\u000f\n\t0C\u0002\u0003H&\u0013\u0011BR;oGRLwN\\\u0019\t\u000f\t-\u0017\u00071\u0001\u0002R\u0005\u0019Qn]4\u0002AM#V\nV0H\u000bR{F+\u0012(B\u001dR{\u0016\nR0C3~#&+S$H\u000bJ{\u0016\nR\u0001\"'RkEkX$F)~#VIT!O)~KEi\u0018\"Z?R\u0013\u0016jR$F%~KE\tI\u0001\u0016O\u0016$H+\u001a8b]RLEMR8s)JLwmZ3s)\u0011\t\tF!6\t\u000f\u0005%F\u00071\u0001\u0002R\u0005\u00013\u000bV'U?\u000e{UK\u0014+`\u001d>{vJR0U\u000b:\u000be\nV0U%&;u)\u0012*T\u0003\u0005\u001aF+\u0014+`\u0007>+f\nV0O\u001f~{ei\u0018+F\u001d\u0006sEk\u0018+S\u0013\u001e;UIU*!\u0003I!XM\\1oiR\u0013\u0018nZ4fe\u000e{WO\u001c;\u0015\t\t}'Q\u001d\t\u0005\u0005\u0003\u0013\t/\u0003\u0003\u0003d\n\r%aB%oi\u0016<WM\u001d\u0005\b\u0005O<\u0004\u0019AA)\u0003!!XM\\1oi&#\u0007f\u0001\u0001\u0003lB!\u0011Q\rBw\u0013\u0011\u0011y/a\u001a\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class TriggerPersistence
implements SqlRepository,
PersistenceSupport,
TriggerMapper,
Logging {
    private final FolderPersistence folderPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final String QUERY_TRIGGER_BY_TRIGGER_ID;
    private final String STMT_INSERT_TRIGGER;
    private final String STMT_UPDATE_TRIGGER;
    private final String STMT_DELETE_TRIGGER;
    private final String STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID;
    private final String STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE;
    private final RowMapper<TemplateTriggerRow> templateTriggerRowMapper;
    private final String INSERT_TEMPLATE_TRIGGER_ROW;
    private final String STMT_GET_TRIGGERED_RELEASES_COUNT;
    private final String INSERT_TRIGGERED_RELEASE_ROW;
    private final String STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID;
    private final String STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID;
    private final String STMT_GET_TENANT_ID_BY_TRIGGER_ID;
    private final String STMT_COUNT_NO_OF_TENANT_TRIGGERS;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T extends Trigger> Function2<SqlRepositoryAdapter, FolderPersistence, RowMapper<T>> triggerMapper() {
        return TriggerMapper.triggerMapper$(this);
    }

    @Override
    public RowMapper<String> triggerIdRowMapper() {
        return TriggerMapper.triggerIdRowMapper$(this);
    }

    public MapSqlParameterSource paramMap2MapSqlParameterSource(scala.collection.immutable.Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public Long sqlInsertTask(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params) {
        return PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, scala.collection.immutable.Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, scala.collection.immutable.Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<scala.collection.immutable.Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<scala.collection.immutable.Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerPersistence triggerPersistence = this;
        synchronized (triggerPersistence) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        TriggerPersistence triggerPersistence = this;
        synchronized (triggerPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public FolderPersistence folderPersistence() {
        return this.folderPersistence;
    }

    public SqlRepositoryAdapter sqlRepositoryAdapter() {
        return this.sqlRepositoryAdapter;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        String QUERY_COUNT_TEMPLATE_TRIGGERS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT COUNT(1)\n         | FROM\n         | " + Schema.RELEASES$.MODULE$.TABLE() + " r\n         | JOIN " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + " tt on tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = r." + Schema.RELEASES$.MODULE$.CI_UID() + "\n         | JOIN " + Schema.TRIGGERS$.MODULE$.TABLE() + " tr on tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + " = tr." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n         | WHERE r." + Schema.RELEASES$.MODULE$.RELEASE_ID() + " = :" + Schema.RELEASES$.MODULE$.RELEASE_ID() + "\n         |"));
        return BoxesRunTime.unboxToInt((Object)this.namedTemplate().queryForObject(QUERY_COUNT_TEMPLATE_TRIGGERS, (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.RELEASES$.MODULE$.RELEASE_ID()), (Object)Ids.getName((String)templateId))})), Integer.TYPE));
    }

    private TriggerQueryBuilder triggerQueryBuilder() {
        return new TriggerQueryBuilder(this.folderPersistence(), this.sqlRepositoryAdapter(), this.dialect(), this.namedTemplate());
    }

    private String QUERY_TRIGGER_BY_TRIGGER_ID() {
        return this.QUERY_TRIGGER_BY_TRIGGER_ID;
    }

    public <T extends Trigger> Option<T> findById(String triggerId) {
        Some some;
        try {
            some = new Some(this.namedTemplate().queryForObject(this.QUERY_TRIGGER_BY_TRIGGER_ID(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.ID()), (Object)triggerId)}))).asJava(), (RowMapper)this.triggerMapper().apply((Object)this.sqlRepositoryAdapter(), (Object)this.folderPersistence())));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Page<Trigger> findBy(TriggerFilters filter, Pageable pageable) {
        return this.triggerQueryBuilder().from(filter).withPageable(pageable).build().execute();
    }

    private String STMT_INSERT_TRIGGER() {
        return this.STMT_INSERT_TRIGGER;
    }

    public Trigger insert(Trigger trigger) {
        MapSqlParameterSource params = this.upsertParams(trigger);
        params.addValue(Schema.TRIGGERS$.MODULE$.TENANT_ID(), (Object)TenantContext$.MODULE$.getTenant());
        return (Trigger)this.sqlInsert(this.pkName(Schema.TRIGGERS$.MODULE$.CI_UID()), this.STMT_INSERT_TRIGGER(), params, (Function1 & Serializable)ciUid -> {
            trigger.setCiUid(ciUid);
            return trigger;
        });
    }

    private String STMT_UPDATE_TRIGGER() {
        return this.STMT_UPDATE_TRIGGER;
    }

    public void update(Trigger trigger) {
        MapSqlParameterSource params = this.upsertParams(trigger);
        this.sqlUpdate(this.STMT_UPDATE_TRIGGER(), params, this.checkCiUpdated(trigger.getId()));
    }

    private MapSqlParameterSource upsertParams(Trigger trigger) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        Integer folderUid = this.folderPersistence().getUid(trigger.getFolderId());
        params.addValue(Schema.TRIGGERS$.MODULE$.FOLDER_UID(), (Object)folderUid);
        params.addValue(Schema.TRIGGERS$.MODULE$.ENABLED(), (Object)Utils.RichBooleanAsInt$.MODULE$.asInteger$extension(Utils$.MODULE$.RichBooleanAsInt(trigger.isEnabled())));
        params.addValue(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE(), (Object)Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(trigger.getTitle()), package$.MODULE$.LONG_VARCHAR_LENGTH()));
        params.addValue(Schema.TRIGGERS$.MODULE$.CI_TYPE(), (Object)trigger.getType().toString());
        params.addValue(Schema.TRIGGERS$.MODULE$.DESCRIPTION(), (Object)Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(trigger.getDescription()), package$.MODULE$.LONG_VARCHAR_LENGTH()));
        params.addValue(Schema.TRIGGERS$.MODULE$.CONTENT(), (Object)new SqlBinaryValue(this.serialize(trigger).getBytes(StandardCharsets.UTF_8)), PersistenceConstants$.MODULE$.BLOB_TYPE());
        params.addValue(Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE(), (Object)trigger.getLastRunDate());
        params.addValue(Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS(), Option$.MODULE$.apply((Object)trigger.getLastRunStatus()).map((Function1 & Serializable)x$1 -> x$1.value()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (Ids.isInRelease((String)trigger.getId())) {
            v0 = params.addValue(Schema.TRIGGERS$.MODULE$.ID(), (Object)Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(trigger.getId()))));
        } else {
            String triggerId = Ids.getName((String)Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(trigger.getId()))));
            trigger.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)triggerId));
            v0 = params.addValue(Schema.TRIGGERS$.MODULE$.ID(), (Object)triggerId);
        }
        return params;
    }

    private String serialize(Trigger trigger) {
        Trigger triggerCopy = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)trigger);
        triggerCopy.setId(Ids.getFolderlessId((String)trigger.getId()));
        triggerCopy.setFolderId(null);
        return CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)triggerCopy);
    }

    private String STMT_DELETE_TRIGGER() {
        return this.STMT_DELETE_TRIGGER;
    }

    public void delete(String triggerId) {
        this.sqlUpdate(this.STMT_DELETE_TRIGGER(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.ID()), (Object)Ids.getFolderlessId((String)triggerId))}))), this.checkCiUpdated(triggerId));
    }

    private String STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID() {
        return this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID;
    }

    public Seq<String> getEnabledReleaseTriggerIds(String templateId) {
        return this.sqlQuery(this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID(), (scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"templateId"), (Object)Ids.getName((String)templateId))})), this.triggerIdRowMapper()).toSeq();
    }

    private String STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE() {
        return this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE;
    }

    private RowMapper<TemplateTriggerRow> templateTriggerRowMapper() {
        return this.templateTriggerRowMapper;
    }

    public Seq<TemplateTriggerRow> getTemplateTriggerRows(Integer releaseCiUid) {
        return this.sqlQuery(this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE(), (scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)releaseCiUid)})), this.templateTriggerRowMapper()).toSeq();
    }

    private String INSERT_TEMPLATE_TRIGGER_ROW() {
        return this.INSERT_TEMPLATE_TRIGGER_ROW;
    }

    public void insertTemplateTriggerRow(TemplateTriggerRow row) {
        this.sqlInsert(this.INSERT_TEMPLATE_TRIGGER_ROW(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)row.releaseCiUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"triggerCiUid"), (Object)row.triggerCiUid())}))));
    }

    private String STMT_GET_TRIGGERED_RELEASES_COUNT() {
        return this.STMT_GET_TRIGGERED_RELEASES_COUNT;
    }

    public int getRunningTriggeredReleasesCount(Integer templateUid) {
        return BoxesRunTime.unboxToInt((Object)this.namedTemplate().queryForObject(this.STMT_GET_TRIGGERED_RELEASES_COUNT(), (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)templateUid)})), Integer.TYPE));
    }

    private String INSERT_TRIGGERED_RELEASE_ROW() {
        return this.INSERT_TRIGGERED_RELEASE_ROW;
    }

    public void insertTriggeredReleaseRow(TriggeredReleaseRow row) {
        this.sqlInsert(this.INSERT_TRIGGERED_RELEASE_ROW(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)row.templateUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID()), (Object)row.triggerUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID()), (Object)row.releaseUid())}))));
    }

    private String STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID() {
        return this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID;
    }

    private String STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID() {
        return this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID;
    }

    public void removeTriggeredReleasesRow(RemoveTriggeredReleaseCondition condition) {
        RemoveTriggeredReleaseCondition removeTriggeredReleaseCondition = condition;
        if (removeTriggeredReleaseCondition instanceof RemoveByReleaseUid) {
            RemoveByReleaseUid removeByReleaseUid = (RemoveByReleaseUid)removeTriggeredReleaseCondition;
            Integer releaseUid = removeByReleaseUid.releaseUid();
            this.sqlUpdate(this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID()), (Object)releaseUid)}))), this.checkDeleteResult("No rows were deleted for releaseUid[" + releaseUid + "]"));
            return;
        }
        if (removeTriggeredReleaseCondition instanceof RemoveByTemplateUid) {
            RemoveByTemplateUid removeByTemplateUid = (RemoveByTemplateUid)removeTriggeredReleaseCondition;
            Integer templateUid = removeByTemplateUid.templateUid();
            this.sqlUpdate(this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)templateUid)}))), this.checkDeleteResult("No rows were deleted for templateUid[" + templateUid + "]"));
            return;
        }
        throw new MatchError((Object)removeTriggeredReleaseCondition);
    }

    private Function1<Object, BoxedUnit> checkDeleteResult(String msg) {
        return (JFunction1.mcVI.sp & Serializable)x0$1 -> {
            int n = x0$1;
            switch (n) {
                case 0: {
                    this.logger().debug((Function0 & Serializable)() -> msg);
                    return;
                }
            }
        };
    }

    private String STMT_GET_TENANT_ID_BY_TRIGGER_ID() {
        return this.STMT_GET_TENANT_ID_BY_TRIGGER_ID;
    }

    public String getTenantIdForTrigger(String triggerId) {
        return (String)this.namedTemplate().queryForObject(this.STMT_GET_TENANT_ID_BY_TRIGGER_ID(), (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.ID()), (Object)triggerId)})), String.class);
    }

    private String STMT_COUNT_NO_OF_TENANT_TRIGGERS() {
        return this.STMT_COUNT_NO_OF_TENANT_TRIGGERS;
    }

    public Integer tenantTriggerCount(String tenantId) {
        return (Integer)this.namedTemplate().queryForObject(this.STMT_COUNT_NO_OF_TENANT_TRIGGERS(), (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.TENANT_ID()), (Object)tenantId)})), Integer.class);
    }

    public TriggerPersistence(FolderPersistence folderPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        TriggerMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.QUERY_TRIGGER_BY_TRIGGER_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT t." + Schema.TRIGGERS$.MODULE$.ID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CI_UID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.ENABLED() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CI_TYPE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CONTENT() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + ",\n       | f." + Schema.FOLDERS$.MODULE$.FOLDER_PATH() + ",\n       | f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.TENANT_ID() + "\n       | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + " t\n       | INNER JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " f on t." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + " = f." + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n       |"));
        this.STMT_INSERT_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | ( " + Schema.TRIGGERS$.MODULE$.ID() + "\n       | , " + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n       | , " + Schema.TRIGGERS$.MODULE$.ENABLED() + "\n       | , " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.CI_TYPE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + "\n       | , " + Schema.TRIGGERS$.MODULE$.CONTENT() + "\n       | , " + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | , " + Schema.TRIGGERS$.MODULE$.TENANT_ID() + "\n       | ) VALUES\n       | ( :" + Schema.TRIGGERS$.MODULE$.ID() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.ENABLED() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.CI_TYPE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.CONTENT() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.TENANT_ID() + "\n       | )\n     "));
        this.STMT_UPDATE_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | SET " + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + " = :" + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.ENABLED() + " = :" + Schema.TRIGGERS$.MODULE$.ENABLED() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + " = :" + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.CI_TYPE() + " = :" + Schema.TRIGGERS$.MODULE$.CI_TYPE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + " = :" + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.CONTENT() + " = :" + Schema.TRIGGERS$.MODULE$.CONTENT() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + " = :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + " = :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n     "));
        this.STMT_DELETE_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n     "));
        this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TRIGGERS$.MODULE$.ID() + "\n       | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + " t\n       | JOIN " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + " tt ON tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + " = t." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n       | JOIN " + Schema.RELEASES$.MODULE$.TABLE() + " r ON tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = r." + Schema.RELEASES$.MODULE$.CI_UID() + "\n       |WHERE\n       | r." + Schema.RELEASES$.MODULE$.RELEASE_ID() + " = :templateId\n       | AND t." + Schema.TRIGGERS$.MODULE$.ENABLED() + " = 1\n     "));
        this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + ", " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + "\n       | FROM " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = :releaseCiUid\n       |"));
        this.templateTriggerRowMapper = (rs, x$2) -> new TemplateTriggerRow(Predef$.MODULE$.int2Integer(rs.getInt(Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID())), Predef$.MODULE$.int2Integer(rs.getInt(Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID())));
        this.INSERT_TEMPLATE_TRIGGER_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + "\n       | (" + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + ", " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + ")\n       | VALUES (:releaseCiUid, :triggerCiUid)\n       |"));
        this.STMT_GET_TRIGGERED_RELEASES_COUNT = "SELECT COUNT(1) FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + " WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + "=:" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID();
        this.INSERT_TRIGGERED_RELEASE_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | (" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + ", " + Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID() + ", " + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + ")\n       | VALUES (:" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + ", :" + Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID() + ", :" + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + ")\n       |"));
        this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + " = :" + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + "\n       |"));
        this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + " = :" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + "\n       |"));
        this.STMT_GET_TENANT_ID_BY_TRIGGER_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TRIGGERS$.MODULE$.TENANT_ID() + "\n       | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n       |"));
        this.STMT_COUNT_NO_OF_TENANT_TRIGGERS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT COUNT(1)\n        | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n        | WHERE " + Schema.TRIGGERS$.MODULE$.TENANT_ID() + " = :" + Schema.TRIGGERS$.MODULE$.TENANT_ID() + "\n        |"));
    }
}

