/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.delivery.activity.DeliveryActivity;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryActivityLogsService;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class DeliveryActivityLogsResource
extends BaseActivityLogsResource {
    private DeliveryPermissionChecker permissions;
    private final ActivityLogRepository activityLogRepository;

    @Autowired
    public DeliveryActivityLogsResource(DeliveryActivityLogsService deliveryActivityLogsService, UserViewConverter userViewConverter, DeliveryPermissionChecker permissions, ActivityLogRepository activityLogRepository) {
        super((BaseActivityLogsService)deliveryActivityLogsService, userViewConverter);
        this.permissions = permissions;
        this.activityLogRepository = activityLogRepository;
    }

    @POST
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchDeliveryLogs(@PathParam(value="deliveryId") String deliveryId, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, LogsFilters filters) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        this.permissions.checkView(deliveryId);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)Sort.unsorted());
        return this.searchLogs(deliveryId, filters, (Pageable)pageable);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/approvals")
    public List<ActivityLogEntryView> searchTrackedItemApprovals(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.activityLogRepository.findAllLogsOf(deliveryId, (ActivityOps)DeliveryActivity.ITEM_TRANSITION_APPROVED, Pageable.unpaged()).stream().map(x$0 -> super.toActivityLogEntryView(x$0)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/logs/users")
    public List<UserView> getUsers(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.getUniqueUsers(deliveryId);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/-]*}/logs/activity-types")
    public List<String> getActivityTypes(@PathParam(value="deliveryId") @IdParam String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.getUniqueActivityTypes(deliveryId);
    }
}

