/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.delivery.events.ConditionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTimelineCalculator;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.delivery.conditions.ConditionGroup;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.CiHelper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Service
@ScalaSignature(bytes="\u0006\u0005\r}a\u0001\u0002\u0015*\u0001QB\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!b\u0001\n\u0003a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\r\u0004!Q1A\u0005\u0002\u0011D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011u\u0004!\u0011!Q\u0001\n]D\u0001B \u0001\u0003\u0006\u0004%\ta \u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0005\u0001\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005}\u0001A!b\u0001\n\u0003\t\t\u0003\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003GAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBA^\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a?\u0001\t\u0003\ti\u0010C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\t-\u0001\u0001\"\u0001\u0003\u001c!9!1\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u0011\t\f\u0001C\u0001\u0005gCqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003N\u0002!\tAa4\t\u000f\t%\b\u0001\"\u0015\u0003l\"I!Q\u001f\u0001\u0012\u0002\u0013E!q\u001f\u0005\b\u0005S\u0004A\u0011CB\u0006\u0005=!U\r\\5wKJL8+\u001a:wS\u000e,'B\u0001\u0016,\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001L\u0017\u0002\u0011\u0011,G.\u001b<fefT!AL\u0018\u0002\u0013ad'/\u001a7fCN,'B\u0001\u00192\u0003%AXMY5bY\u0006\u00147OC\u00013\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001QgO\"H!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006g24GG\u001b\u0006\u0002\u0001\u0006AqM]5{u2,G-\u0003\u0002C{\t9Aj\\4hS:<\u0007C\u0001#F\u001b\u0005I\u0013B\u0001$*\u0005i!U\r\\5wKJLH+[7fY&tWmQ1mGVd\u0017\r^8s!\t!\u0005*\u0003\u0002JS\t!B)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW-\u0016;jYN\f!\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ssV\tA\n\u0005\u0002N!6\taJ\u0003\u0002PW\u0005Q!/\u001a9pg&$xN]=\n\u0005Es%A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005)\u0006C\u0001,Y\u001b\u00059&BA(.\u0013\tIvKA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A/\u0011\u0005y\u0003W\"A0\u000b\u0005)j\u0013BA1`\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012!\u001a\t\u0003=\u001aL!aZ0\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!E1sG\"Lg/\u001b8h'\u0016\u0014h/[2fA\u0005!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016,\u0012a\u001b\t\u0003=2L!!\\0\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0002\n1bY5JIN+'O^5dKV\t\u0011\u000f\u0005\u0002_e&\u00111o\u0018\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{[\u0005\u0011AMY\u0005\u0003yf\u0014\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%A\u0007g_2$WM]*feZL7-Z\u000b\u0003\u0003\u0003\u00012AXA\u0002\u0013\r\t)a\u0018\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001d\u0019|G\u000eZ3s'\u0016\u0014h/[2fA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0011M,7-\u001e:jifT1!a\u00060\u0003!!W\r\u001d7ps&$\u0018\u0002BA\u000e\u0003#\u00111BU8mKN+'O^5dK\u0006a!o\u001c7f'\u0016\u0014h/[2fA\u0005AQM^3oi\n+8/\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*5\na!\u001a<f]R\u001c\u0018\u0002BA\u0017\u0003O\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003k\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0002JA\u0011A\t\u0001\u0005\u0006\u0015V\u0001\r\u0001\u0014\u0005\u0006'V\u0001\r!\u0016\u0005\u00067V\u0001\r!\u0018\u0005\u0006GV\u0001\r!\u001a\u0005\u0006SV\u0001\ra\u001b\u0005\u0006_V\u0001\r!\u001d\u0005\u0006kV\u0001\ra\u001e\u0005\u0007}V\u0001\r!!\u0001\t\u000f\u0005%Q\u00031\u0001\u0002\u000e!9\u0011qD\u000bA\u0002\u0005\r\u0002fA\u000b\u0002NA!\u0011qJA3\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013AC1o]>$\u0018\r^5p]*!\u0011qKA-\u0003\u001d1\u0017m\u0019;pefTA!a\u0017\u0002^\u0005)!-Z1og*!\u0011qLA1\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA2\u0003\ry'oZ\u0005\u0005\u0003O\n\tFA\u0005BkR|w/\u001b:fI\u0006Yq-\u001a;EK2Lg/\u001a:z)\u0011\ti'a\u001f\u0011\t\u0005=\u0014qO\u0007\u0003\u0003cR1\u0001LA:\u0015\r\t)(L\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u0014\u0011\u000f\u0002\t\t\u0016d\u0017N^3ss\"9\u0011Q\u0010\fA\u0002\u0005}\u0014A\u00033fY&4XM]=JIB!\u0011\u0011QAH\u001d\u0011\t\u0019)a#\u0011\u0007\u0005\u0015u'\u0004\u0002\u0002\b*\u0019\u0011\u0011R\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\tiiN\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055u\u0007K\u0002\u0017\u0003/\u0003B!!'\u0002*6\u0011\u00111\u0014\u0006\u0005\u0003'\niJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001B2pe\u0016TA!a)\u0002&\u0006QQ.[2s_6,G/\u001a:\u000b\u0005\u0005\u001d\u0016AA5p\u0013\u0011\tY+a'\u0003\u000bQKW.\u001a3\u0002\u001d\u0015D\u0018n\u001d;t\t\u0016d\u0017N^3ssR!\u0011\u0011WA\\!\r1\u00141W\u0005\u0004\u0003k;$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003{:\u0002\u0019AA@Q\r9\u0012qS\u0001\u000fGJ,\u0017\r^3EK2Lg/\u001a:z)\u0011\ti'a0\t\r1B\u0002\u0019AA7Q\rA\u0012q\u0013\u0015\u00041\u0005\u0015\u0007\u0003BAd\u0003+l!!!3\u000b\t\u0005-\u0017QZ\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002P\u0006E\u0017AB2p[6|gNC\u0002\u0002TF\naaZ8pO2,\u0017\u0002BAl\u0003\u0013\u0014\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h)\u0019\ti'a7\u0002^\"1A&\u0007a\u0001\u0003[Bq!a8\u001a\u0001\u0004\t\t,A\u0005sK^\u0014\u0018\u000e^3JI\"\u001a\u0011$a&\u0002\u001dU\u0004H-\u0019;f\t\u0016d\u0017N^3ssR!\u0011QNAt\u0011\u001d\tIO\u0007a\u0001\u0003[\nq!\u001e9eCR,G\rK\u0002\u001b\u0003/\u000ba\u0002Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0002r\u0006]\bc\u0001\u001c\u0002t&\u0019\u0011Q_\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003{Z\u0002\u0019AA@Q\rY\u0012qS\u0001\fkB$\u0017\r^3Ti\u0006<W\r\u0006\u0004\u0002\u0000\n\u0015!q\u0001\t\u0005\u0003_\u0012\t!\u0003\u0003\u0003\u0004\u0005E$!B*uC\u001e,\u0007bBA?9\u0001\u0007\u0011q\u0010\u0005\b\u0003Sd\u0002\u0019AA\u0000Q\ra\u0012qS\u0001\u0011kB$\u0017\r^3Ue\u0006t7/\u001b;j_:$bAa\u0004\u0003\u0016\t]\u0001\u0003BA8\u0005#IAAa\u0005\u0002r\tQAK]1og&$\u0018n\u001c8\t\u000f\u0005uT\u00041\u0001\u0002\u0000!9\u0011\u0011^\u000fA\u0002\t=\u0001fA\u000f\u0002\u0018R1!q\u0002B\u000f\u0005?Aa\u0001\f\u0010A\u0002\u00055\u0004bBAu=\u0001\u0007!q\u0002\u0015\u0004=\u0005]\u0015\u0001E;qI\u0006$XmQ8oI&$\u0018n\u001c8t)\u0019\u00119Ca\u0010\u0003DA1!\u0011\u0006B\u001a\u0005sqAAa\u000b\u000309!\u0011Q\u0011B\u0017\u0013\u0005A\u0014b\u0001B\u0019o\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u001b\u0005o\u00111aU3r\u0015\r\u0011\td\u000e\t\u0005\u0003_\u0012Y$\u0003\u0003\u0003>\u0005E$!C\"p]\u0012LG/[8o\u0011\u001d\u0011\te\ba\u0001\u0005\u001f\t!c\u001c:jO&t\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"9!QI\u0010A\u0002\t=\u0011!E;qI\u0006$X\r\u001a+sC:\u001c\u0018\u000e^5p]\u000611/Z1sG\"$\u0002Ba\u0013\u0003\\\tM$Q\u0010\t\u0007\u0005\u001b\u00129&!\u001c\u000e\u0005\t=#\u0002\u0002B)\u0005'\nA!\u001e;jY*\u0011!QK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003Z\t=#\u0001\u0002'jgRDqA!\u0018!\u0001\u0004\u0011y&A\u0004gS2$XM]:\u0011\t\t\u0005$qN\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005)am\u001c:ng*!!\u0011\u000eB6\u0003\t1\u0018GC\u0002\u0003n5\n1!\u00199j\u0013\u0011\u0011\tHa\u0019\u0003/\u0005\u00137\u000f\u001e:bGR$U\r\\5wKJLh)\u001b7uKJ\u001c\bb\u0002B;A\u0001\u0007!qO\u0001\u0005a\u0006<W\rE\u0002W\u0005sJ1Aa\u001fX\u0005\u0011\u0001\u0016mZ3\t\u000f\t}\u0004\u00051\u0001\u0003\u0002\u00069qN\u001d3fe\nK\b\u0003\u0002B1\u0005\u0007KAA!\"\u0003d\t\tB)\u001a7jm\u0016\u0014\u0018p\u0014:eKJlu\u000eZ3)\u0007\u0001\n9*A\u0006hKR$\u0016.\\3mS:,GC\u0002BG\u00053\u0013Y\n\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\u0011\u0011\u0019Ja\u001a\u0002\u000bYLWm^:\n\t\t]%\u0011\u0013\u0002\u0011\t\u0016d\u0017N^3ssRKW.\u001a7j]\u0016Dq!! \"\u0001\u0004\ty\bC\u0004\u0003\u001e\u0006\u0002\rAa(\u0002\u00079|w\u000f\u0005\u0003\u0003\"\n-VB\u0001BR\u0015\u0011\u0011)Ka*\u0002\tQLW.\u001a\u0006\u0005\u0005S\u000b\t'\u0001\u0003k_\u0012\f\u0017\u0002\u0002BW\u0005G\u0013\u0001\u0002R1uKRKW.\u001a\u0015\u0004C\u0005]\u0015aC4fiJ+G.Z1tKN$BA!.\u0003>B1!Q\nB,\u0005o\u0003BAa$\u0003:&!!1\u0018BI\u0005]!U\r\\5wKJLh\t\\8x%\u0016dW-Y:f\u0013:4w\u000eC\u0004\u0002~\t\u0002\r!a )\u0007\t\n9*\u0001\u0011gS:$G)\u001a7jm\u0016\u0014\u0018.Z:SK\u001a,'/\u001a8dS:<'+\u001a7fCN,G\u0003\u0002Bc\u0005\u000f\u0004bA!\u000b\u00034\u0005}\u0004b\u0002BeG\u0001\u0007\u0011qP\u0001\ne\u0016dW-Y:f\u0013\u0012D3aIAL\u0003\u00152\u0017N\u001c3BGRLg/\u001a#fY&4XM]5fgJ+g-\u001a:f]\u000eLgn\u001a$pY\u0012,'\u000f\u0006\u0003\u0003R\n\r\bC\u0002B\u0015\u0005g\u0011\u0019\u000e\u0005\u0003\u0003V\n}WB\u0001Bl\u0015\u0011\u0011INa7\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0004\u0005;t\u0015aA:rY&!!\u0011\u001dBl\u00055\u0019\u0015.\u00133XSRDG+\u001b;mK\"9!Q\u001d\u0013A\u0002\u0005}\u0014\u0001\u00034pY\u0012,'/\u00133)\u0007\u0011\n9*\u0001\tdQ\u0016\u001c7.S:Va\u0012\fG/\u00192mKR1\u0011\u0011\u001fBw\u0005cDqAa<&\u0001\u0004\ti'\u0001\tfq&\u001cH/\u001b8h\t\u0016d\u0017N^3ss\"I!1_\u0013\u0011\u0002\u0003\u0007\u0011qP\u0001\u0007C\u000e$\u0018n\u001c8\u00025\rDWmY6JgV\u0003H-\u0019;bE2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te(\u0006BA@\u0005w\\#A!@\u0011\t\t}8qA\u0007\u0003\u0007\u0003QAaa\u0001\u0004\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003':\u0014\u0002BB\u0005\u0007\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0011\t\tp!\u0004\t\u000f\r=q\u00051\u0001\u0002\u0000\u0006)1\u000f^1hK\"\u001a\u0001aa\u0005\u0011\t\rU11D\u0007\u0003\u0007/QAa!\u0007\u0002^\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\ru1q\u0003\u0002\b'\u0016\u0014h/[2f\u0001")
public class DeliveryService
implements DeliveryTimelineCalculator,
DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final ArchivingService archivingService;
    private final ReleaseSearchService releaseSearchService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    @Override
    public DeliveryTimeline calculateTimeline(Delivery delivery, DateTime now) {
        return DeliveryTimelineCalculator.calculateTimeline$(this, delivery, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return DeliveryTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryService deliveryService = this;
        synchronized (deliveryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public Delivery getDelivery(String deliveryId) {
        Delivery delivery = this.getDeliveryOrPattern(deliveryId);
        this.checkIsDelivery(delivery);
        return delivery;
    }

    @Timed
    public boolean existsDelivery(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    @VisibleForTesting
    public Delivery createDelivery(Delivery delivery) {
        return this.createDelivery(delivery, true);
    }

    @Timed
    public Delivery createDelivery(Delivery delivery, boolean rewriteId) {
        this.logger().debug((Function0 & Serializable)() -> "Creating new release delivery [" + delivery + "]");
        this.validateDelivery(delivery);
        String deliveryId = rewriteId || delivery.getId() == null || !Ids.isDeliveryId((String)delivery.getId()) ? this.factory().deliveryId() : delivery.getId();
        delivery.setId(deliveryId);
        CiHelper.rewriteWithNewId((ConfigurationItem)delivery, (String)deliveryId);
        delivery.getStages().forEach(stage -> Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
            transition.setStage(stage);
            return BoxedUnit.UNIT;
        }));
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable)event -> {
            DeliveryService.$anonfun$createDelivery$4(this, event);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public Delivery updateDelivery(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating release delivery [" + updated + "]");
        this.validateDelivery(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting release delivery [" + deliveryId + "]");
        Delivery delivery = this.deliveryRepository().read(deliveryId);
        this.checkIsDelivery(delivery);
        this.doDelete(deliveryId);
    }

    @Timed
    public Stage updateStage(String deliveryId, Stage updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating stage '" + updated + "' on delivery '" + deliveryId + "'");
        Checks.checkNotNull((Object)updated, (String)"Stage");
        Delivery delivery = this.getDelivery(deliveryId);
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Stage original = delivery.getStageByIdOrTitle(updated.getId());
        Stage originalBeforeChanges = (Stage)CiCloneHelper.cloneCi((ConfigurationItem)original);
        original.setOwner(updated.getOwner());
        original.setTeam(updated.getTeam());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(originalBeforeChanges, original, delivery));
        return original;
    }

    @Timed
    public Transition updateTransition(String deliveryId, Transition updated) {
        return this.updateTransition(this.getDelivery(deliveryId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery delivery, Transition updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating transition [" + updated + "]");
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Transition original = delivery.getTransitionByIdOrTitle(updated.getId());
        Transition originalBeforeChanges = (Transition)CiCloneHelper.cloneCi((ConfigurationItem)original);
        Stage stage = original.getStage();
        this.checkIsUpdatable(stage);
        this.validateTransition(delivery, stage, updated);
        scala.collection.immutable.Seq<Condition> updatedConditions = this.updateConditions(original, updated);
        original.setAutomated(updated.isAutomated());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(originalBeforeChanges, updated, delivery));
        updatedConditions.foreach((Function1 & Serializable)condition -> {
            DeliveryService.$anonfun$updateTransition$2(this, original, delivery, condition);
            return BoxedUnit.UNIT;
        });
        return original;
    }

    private scala.collection.immutable.Seq<Condition> updateConditions(Transition originalTransition, Transition updatedTransition) {
        Buffer originalConditions = CollectionConverters$.MODULE$.ListHasAsScala(originalTransition.getAllConditions()).asScala();
        Buffer updatedConditions = CollectionConverters$.MODULE$.ListHasAsScala(updatedTransition.getAllConditions()).asScala();
        Checks.checkArgument((originalConditions.size() == updatedConditions.size() ? 1 : 0) != 0, (String)"Not permitted to add or remove conditions on a running delivery", (Object[])new Object[0]);
        return ((IterableOnceOps)((IterableOps)originalConditions.zip((IterableOnce)updatedConditions)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Condition condition;
                Condition original = (Condition)tuple2._1();
                Condition updated = (Condition)tuple2._2();
                String string = original.getId();
                String string2 = updated.getId();
                Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)("Updating order or structure of conditions not allowed on a running delivery. Expected condition '" + original.getId() + "', got '" + updated.getId() + "''"), (Object[])new Object[0]);
                Type type = original.getType();
                Type type2 = updated.getType();
                Checks.checkArgument((!(type != null ? !type.equals(type2) : type2 != null) ? 1 : 0) != 0, (String)"Condition type cannot be changed on a running delivery", (Object[])new Object[0]);
                Condition condition2 = original;
                if (condition2 instanceof ConditionGroup) {
                    return None$.MODULE$;
                }
                if (condition2 != null && (condition = condition2).isSatisfied()) {
                    return None$.MODULE$;
                }
                Buffer changedProps = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(original.getInputProperties()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.areEqual((ConfigurationItem)original, (ConfigurationItem)updated)));
                changedProps.foreach((Function1 & Serializable)pd -> {
                    pd.set((ConfigurationItem)original, pd.get((ConfigurationItem)updated));
                    return BoxedUnit.UNIT;
                });
                if (changedProps.nonEmpty()) {
                    return new Some((Object)original);
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    @Timed
    public List<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET(), this.deliveryRepository().search$default$7())).asJava();
    }

    @Timed
    public DeliveryTimeline getTimeline(String deliveryId, DateTime now) {
        Delivery delivery = this.getDelivery(deliveryId);
        return this.calculateTimeline(delivery, now);
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> releases = this.deliveryRepository().findReleasesByDeliveryId(deliveryId);
        Set allReleaseIds = this.deliveryRepository().getByIdOrTitle(deliveryId).getReleaseIds();
        scala.collection.immutable.Seq seq = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(allReleaseIds).asScala().filterNot((Function1 & Serializable)fullId -> BoxesRunTime.boxToBoolean((boolean)DeliveryService.$anonfun$getReleases$1(releases, fullId)))).toSeq();
        scala.collection.immutable.Seq archivedReleases = Nil$.MODULE$.equals(seq) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty() : (scala.collection.immutable.Seq)this.archivingService().searchReleasesBasicExtByReleaseIds(seq).map((Function1 & Serializable)item -> new DeliveryFlowReleaseInfo(Ids.getName((String)item.id()), item.title(), item.status(), item.startDate(), item.endDate(), true));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releases.$plus$plus((IterableOnce)archivedReleases)).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingRelease(String releaseId) {
        return this.deliveryRepository().findDeliveriesReferencingReleaseId(releaseId);
    }

    @Timed
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolder(String folderId) {
        return this.deliveryRepository().findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        Checks.checkArgument((boolean)existingDelivery.isUpdatable(), (String)("Cannot " + action + " release delivery '" + existingDelivery.getTitle() + "' because it is " + existingDelivery.getStatus()), (Object[])new Object[0]);
    }

    public void checkIsUpdatable(Stage stage) {
        Checks.checkArgument((boolean)stage.isOpen(), (String)("Cannot update transition on stage '" + stage.getTitle() + "' because it is COMPLETED"), (Object[])new Object[0]);
    }

    @Override
    public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static final /* synthetic */ void $anonfun$createDelivery$4(DeliveryService $this, XLReleaseEvent event) {
        $this.eventBus().publish(event);
    }

    public static final /* synthetic */ void $anonfun$updateTransition$2(DeliveryService $this, Transition original$1, Delivery delivery$2, Condition condition) {
        $this.eventBus().publish((XLReleaseEvent)new ConditionUpdatedEvent(condition, original$1, delivery$2));
    }

    public static final /* synthetic */ boolean $anonfun$getReleases$1(scala.collection.immutable.Seq releases$1, String fullId) {
        return ((SeqOps)releases$1.map((Function1 & Serializable)x$2 -> x$2.getId())).contains((Object)Ids.getName((String)fullId));
    }

    @Autowired
    public DeliveryService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, ArchivingService archivingService, ReleaseSearchService releaseSearchService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.archivingService = archivingService;
        this.releaseSearchService = releaseSearchService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryTimelineCalculator.$init$(this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

