/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryHook;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalContextRegistry {
    private static final Logger logger = LoggerFactory.getLogger(GlobalContextRegistry.class);
    private static ConcurrentHashMap<DescriptorRegistryId, GlobalContext> contexts = new ConcurrentHashMap();

    private GlobalContextRegistry() {
    }

    public static GlobalContext getGlobalContext(DescriptorRegistryId registryId) {
        return contexts.computeIfAbsent(registryId, id -> {
            GlobalContext gc = new GlobalContext();
            DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)registryId).registerHook(new DescriptorRegistryHook(){

                public void onClose(IDescriptorRegistry registry) {
                    logger.debug("Removing GlobalContext that belongs to registry {} from GlobalContextRegistry", (Object)registry.getId());
                    contexts.remove(registry.getId());
                }
            });
            return gc;
        });
    }

    public static GlobalContext unregister(DescriptorRegistryId registryId) {
        return contexts.remove(registryId);
    }

    private static IDescriptorRegistry getDescriptorRegistry(PropertyDescriptor pd) {
        DescriptorRegistryId typeSource = pd.getTypeSource();
        IDescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)typeSource);
        return registry;
    }

    private static GlobalContext getGlobalContext(PropertyDescriptor pd) {
        IDescriptorRegistry descriptorRegistry = GlobalContextRegistry.getDescriptorRegistry(pd);
        DescriptorRegistryId descriptorRegistryId = descriptorRegistry.getId();
        return GlobalContextRegistry.getGlobalContext(descriptorRegistryId);
    }

    static String lookup(PropertyDescriptor propertyDescriptor) {
        GlobalContext globalContext = GlobalContextRegistry.getGlobalContext(propertyDescriptor);
        return globalContext.lookup(propertyDescriptor);
    }

    static void register(PropertyDescriptor pd, String defaultValue) {
        GlobalContext globalContext = GlobalContextRegistry.getGlobalContext(pd);
        globalContext.register(pd, defaultValue);
    }

    static void register(PropertyDescriptor pd, PropertyDescriptor inheritedFrom) {
        GlobalContext globalContext = GlobalContextRegistry.getGlobalContext(pd);
        globalContext.register(pd, inheritedFrom);
    }

    public static void copy(DescriptorRegistryId from, DescriptorRegistryId to) {
        GlobalContext sourceGlobalContext = GlobalContextRegistry.getGlobalContext(from);
        GlobalContext targetGlobalContext = GlobalContextRegistry.getGlobalContext(to);
        targetGlobalContext.copyFrom(sourceGlobalContext);
    }
}

