/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.NotRanChangeSetFilter;
import liquibase.changelog.filter.UpToTagChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.HubHandler;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.lockservice.LockService;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.MdcObject;

public class ChangelogSyncCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"changelogSync"};
    public static final CommandArgumentDefinition<ChangeExecListener> HUB_CHANGE_EXEC_LISTENER_ARG;
    private String tag = null;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Marks all changes as executed in the database");
    }

    @Override
    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(LockService.class, DatabaseChangeLog.class, ChangeLogParameters.class);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        String changeLogFile = commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
        DatabaseChangeLog changeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        BufferedLogService bufferLog = new BufferedLogService();
        HubHandler hubHandler = null;
        try {
            ChangeLogIterator runChangeLogIterator = this.buildChangeLogIterator(this.tag, changeLog, changeLogParameters.getContexts(), changeLogParameters.getLabels(), database);
            CompositeLogService compositeLogService = new CompositeLogService(true, bufferLog);
            hubHandler = new HubHandler(database, changeLog, changeLogFile, commandScope.getArgumentValue(HUB_CHANGE_EXEC_LISTENER_ARG));
            HubChangeExecListener changeLogSyncListener = hubHandler.startHubForChangelogSync(changeLogParameters, this.tag, this.buildChangeLogIterator(this.tag, changeLog, changeLogParameters.getContexts(), changeLogParameters.getLabels(), database));
            AtomicInteger changesetCount = new AtomicInteger(0);
            HashMap<String, Object> scopeVars = new HashMap<String, Object>(2);
            scopeVars.put(Scope.Attr.logService.name(), compositeLogService);
            scopeVars.put("changesetCount", changesetCount);
            Scope.child(scopeVars, () -> runChangeLogIterator.run(new ChangeLogSyncVisitor(database, changeLogSyncListener), new RuntimeEnvironment(database, changeLogParameters.getContexts(), changeLogParameters.getLabels())));
            Scope.getCurrentScope().addMdcValue("changesetSyncCount", changesetCount.toString());
            hubHandler.postUpdateHub(bufferLog);
            try (MdcObject changelogSyncOutcome = Scope.getCurrentScope().addMdcValue("changelogSyncOutcome", "success");){
                Scope.getCurrentScope().getLog(this.getClass()).info("Finished executing " + this.defineCommandNames()[0][0] + " command");
            }
        }
        catch (Exception e) {
            if (hubHandler != null) {
                hubHandler.postUpdateHubExceptionHandling(bufferLog, e.getMessage());
            }
            try (MdcObject changelogSyncOutcome = Scope.getCurrentScope().addMdcValue("changelogSyncOutcome", "fail");){
                Scope.getCurrentScope().getLog(this.getClass()).warning("Failed executing " + this.defineCommandNames()[0][0] + " command");
            }
            throw e;
        }
    }

    private ChangeLogIterator buildChangeLogIterator(String tag, DatabaseChangeLog changeLog, Contexts contexts, LabelExpression labelExpression, Database database) throws DatabaseException {
        if (tag == null) {
            return new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(database));
        }
        List<RanChangeSet> ranChangeSetList = database.getRanChangeSetList();
        return new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(database), new UpToTagChangeSetFilter(tag, ranChangeSetList));
    }

    protected void setTag(String tag) {
        this.tag = tag;
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        HUB_CHANGE_EXEC_LISTENER_ARG = builder.argument("changeExecListener", ChangeExecListener.class).hidden().description("Class that will be used to listen to changes to be sent to Hub (if required)").build();
    }
}

