/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.time.Duration;
import java.util.Map;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.SessionRepository;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.util.Assert;

public class MapSessionRepository
implements SessionRepository<MapSession> {
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private final Map<String, Session> sessions;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    public MapSessionRepository(Map<String, Session> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException("sessions cannot be null");
        }
        this.sessions = sessions;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Override
    public void save(MapSession session) {
        if (!session.getId().equals(session.getOriginalId())) {
            this.sessions.remove(session.getOriginalId());
        }
        MapSession saved = new MapSession(session);
        saved.setSessionIdGenerator(this.sessionIdGenerator);
        this.sessions.put(session.getId(), saved);
    }

    @Override
    public MapSession findById(String id) {
        Session saved = this.sessions.get(id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.deleteById(saved.getId());
            return null;
        }
        MapSession result = new MapSession(saved);
        result.setSessionIdGenerator(this.sessionIdGenerator);
        return result;
    }

    @Override
    public void deleteById(String id) {
        this.sessions.remove(id);
    }

    @Override
    public MapSession createSession() {
        MapSession result = new MapSession(this.sessionIdGenerator);
        result.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return result;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        Assert.notNull((Object)sessionIdGenerator, (String)"sessionIdGenerator cannot be null");
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

