/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.MetadataIncludingCiJsonWriter;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.rest.FormatFactory;
import com.xebialabs.xltype.serialization.xstream.CiXStreamWriter;
import jakarta.ws.rs.core.MediaType;
import java.io.Writer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XlrFormatFactory
extends FormatFactory {
    private ObjectMapper objectMapper;

    @Autowired
    public XlrFormatFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CiWriter createCiWriter(MediaType mediaType, Writer writer) {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return new MetadataIncludingCiJsonWriter(writer, this.objectMapper);
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return new CiXStreamWriter((HierarchicalStreamWriter)new PrettyPrintWriter(writer));
        }
        throw new IllegalArgumentException("Unsupported MediaType: " + String.valueOf(mediaType));
    }
}

