/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.xebialabs.xlrelease.principaldata.LdapDataHelper;
import java.util.Optional;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.Assert;

public class LdapGroupEmailProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapGroupEmailProvider.class);
    private final SearchControls searchControls = new SearchControls();
    private final SpringSecurityLdapTemplate template;
    private String searchBase = "";
    private String searchFilter;
    private String groupEmailAttribute;

    public LdapGroupEmailProvider(String searchBase, String searchFilter, BaseLdapPathContextSource contextSource) {
        this(searchBase, searchFilter, new SpringSecurityLdapTemplate((ContextSource)contextSource));
        if (searchBase.length() == 0) {
            logger.info("SearchBase not set. Searches will be performed from the root: " + String.valueOf(contextSource.getBaseLdapName()));
        }
    }

    LdapGroupEmailProvider(String searchBase, String searchFilter, SpringSecurityLdapTemplate template) {
        Assert.notNull((Object)template, (String)"template must not be null.");
        Assert.notNull((Object)searchFilter, (String)"searchFilter must not be null.");
        Assert.notNull((Object)searchBase, (String)"searchBase must not be null (an empty string is acceptable).");
        this.searchFilter = searchFilter;
        this.searchBase = searchBase;
        this.template = template;
        this.setSearchSubtree(true);
    }

    public String getGroupEmail(String groupName) {
        return this.searchForGroupData(groupName).map(data -> LdapDataHelper.readStringAttribute(groupName, data, this.groupEmailAttribute)).orElse(null);
    }

    Optional<DirContextOperations> searchForGroupData(String groupName) {
        logger.info("Searching for group '{}', with group search {}", (Object)groupName, (Object)this);
        try {
            this.template.setSearchControls(this.searchControls);
            return Optional.ofNullable(this.template.searchForSingleEntry(this.searchBase, this.searchFilter, (Object[])new String[]{groupName}));
        }
        catch (IncorrectResultSizeDataAccessException notFound) {
            if (notFound.getActualSize() == 0) {
                logger.warn("Ldap group '{}' not found with search {} in directory ", (Object)groupName, (Object)this);
            } else {
                logger.warn("Found more({} groups) than a single Ldap group '{}' with search {} in directory", new Object[]{notFound.getActualSize(), groupName, this});
            }
        }
        catch (Exception e) {
            logger.warn("Unknown Ldap exception", (Throwable)e);
        }
        return Optional.empty();
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchControls.setSearchScope(searchSubtree ? 2 : 1);
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchControls.setTimeLimit(searchTimeLimit);
    }

    public void setGroupEmailAttribute(String groupEmailAttribute) {
        this.groupEmailAttribute = groupEmailAttribute;
        this.searchControls.setReturningAttributes(new String[]{this.groupEmailAttribute});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ searchFilter: '").append(this.searchFilter).append("', ");
        sb.append("searchBase: '").append(this.searchBase).append("'");
        sb.append(", scope: ").append(this.searchControls.getSearchScope() == 2 ? "subtree" : "single-level, ");
        sb.append(", searchTimeLimit: ").append(this.searchControls.getTimeLimit());
        sb.append(", groupEmailAttribute").append(this.groupEmailAttribute).append(" ]");
        return sb.toString();
    }
}

