/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.scheduler.RestartableScheduledExecutorService;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.XlrServiceLifecycle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u000e\u001c\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u001dQ\u0007\u00011A\u0005\n-Dqa\u001c\u0001A\u0002\u0013%\u0001\u000f\u0003\u0004w\u0001\u0001\u0006K\u0001\u001c\u0005\bo\u0002\u0001\r\u0011\"\u0003l\u0011\u001dA\b\u00011A\u0005\neDaa\u001f\u0001!B\u0013a\u0007\"\u0002?\u0001\t\u0003Y\u0007\"B?\u0001\t\u0003r\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0004\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002>\u0001!\t\"a\u0010\t\u0013\u00055\u0004!%A\u0005\u0012\u0005=\u0004\"CAB\u0001E\u0005I\u0011CA8\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fAq!a\"\u0001\t\u0013\tI\tC\u0005\u0002\u001a\u0002\t\n\u0011\"\u0003\u0002\u001c\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAc\u0001\u0011%\u0011q\u0019\u0002\u0012!J,\u0017I]2iSZ,7+\u001a:wS\u000e,'B\u0001\u000f\u001e\u0003\u001d\u0019XM\u001d<jG\u0016T!AH\u0010\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0011\"\u0003%AXMY5bY\u0006\u00147OC\u0001#\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001QeK\u001a\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\ta\u0013'D\u0001.\u0015\tqs&A\u0003tY\u001a$$NC\u00011\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001a.\u0005\u001daunZ4j]\u001e\u0004\"\u0001N\u001b\u000e\u0003mI!AN\u000e\u0003'ac'oU3sm&\u001cW\rT5gK\u000eL8\r\\3\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007C\u0001\u001b:\u0013\tQ4D\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}j\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011I\u0010\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aD1sG\"Lg/\u001b8h\u0007>tg-[4\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019k\u0012AB2p]\u001aLw-\u0003\u0002I\u000b\nA\u0012I]2iSZLgnZ*fiRLgnZ:NC:\fw-\u001a:\u0002)A\u0014X-\u0011:dQ&4\u0018N\\4Fq\u0016\u001cW\u000f^8s!\tYe*D\u0001M\u0015\tiU$A\u0005tG\",G-\u001e7fe&\u0011q\n\u0014\u0002$%\u0016\u001cH/\u0019:uC\ndWmU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fQ\u0011!\u0011k\u00181\u0011\u0005IkV\"A*\u000b\u0005Q+\u0016AC1o]>$\u0018\r^5p]*\u0011akV\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA\u0016,A\u0003cK\u0006t7O\u0003\u0002[7\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001]\u0003\ry'oZ\u0005\u0003=N\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003\u0005\fQ\u0002\u001d:f[\u0005\u00148\r[5wS:<\u0017A\u0002\u001fj]&$h\bF\u0003eK\u001a<\u0007\u000e\u0005\u00025\u0001!)q'\u0002a\u0001q!)1(\u0002a\u0001y!)!)\u0002a\u0001\u0007\")\u0011*\u0002a\u0001\u0015\"\"\u0001.U0a\u0003\u001d)g.\u00192mK\u0012,\u0012\u0001\u001c\t\u0003M5L!A\\\u0014\u0003\u000f\t{w\u000e\\3b]\u0006YQM\\1cY\u0016$w\fJ3r)\t\tH\u000f\u0005\u0002'e&\u00111o\n\u0002\u0005+:LG\u000fC\u0004v\u000f\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0013'\u0001\u0005f]\u0006\u0014G.\u001a3!\u0003)\u0019\u0017\r^2iS:<W\u000b]\u0001\u000fG\u0006$8\r[5oOV\u0003x\fJ3r)\t\t(\u0010C\u0004v\u0015\u0005\u0005\t\u0019\u00017\u0002\u0017\r\fGo\u00195j]\u001e,\u0006\u000fI\u0001\nSN,e.\u00192mK\u0012\f\u0001bZ3u\u001fJ$WM\u001d\u000b\u0002\u007fB\u0019a%!\u0001\n\u0007\u0005\rqEA\u0002J]R\fq\u0001Z8Ti\u0006\u0014H\u000fF\u0001r\u0003\u0019!wn\u0015;pa\u0006Q\u0002O]3Be\u000eD\u0017N^3D_6\u0004H.\u001a;fIJ+G.Z1tKR\u0019\u0011/a\u0004\t\u000f\u0005E\u0001\u00031\u0001\u0002\u0014\u0005)QM^3oiB!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011AB3wK:$8OC\u0002\u0002\u001eu\ta\u0001Z8nC&t\u0017\u0002BA\u0011\u0003/\u0011QCU3mK\u0006\u001cXmQ8na2,G/\u001a3Fm\u0016tG\u000fK\u0002\u0011\u0003K\u0001B!a\n\u0002,5\u0011\u0011\u0011\u0006\u0006\u0004\u00033i\u0012\u0002BA\u0017\u0003S\u0011\u0011bU;cg\u000e\u0014\u0018NY3\u00021A\u0014X-\u0011:dQ&4X-\u00112peR,GMU3mK\u0006\u001cX\rF\u0002r\u0003gAq!!\u0005\u0012\u0001\u0004\t)\u0004\u0005\u0003\u0002\u0016\u0005]\u0012\u0002BA\u001d\u0003/\u00111CU3mK\u0006\u001cX-\u00112peR,G-\u0012<f]RD3!EA\u0013\u0003)\u0001(/Z!sG\"Lg/\u001a\u000b\bc\u0006\u0005\u0013QJA)\u0011\u001d\t\u0019E\u0005a\u0001\u0003\u000b\nqA]3mK\u0006\u001cX\r\u0005\u0003\u0002H\u0005%SBAA\u000e\u0013\u0011\tY%a\u0007\u0003\u000fI+G.Z1tK\"A\u0011q\n\n\u0011\u0002\u0003\u0007A.\u0001\u0007dQ\u0016\u001c7.\u00128bE2,G\r\u0003\u0005\u0002TI\u0001\n\u00111\u0001m\u0003=\u0011XmY8wKJLe-\u0012=jgR\u001c\bf\u0001\n\u0002XA!\u0011\u0011LA5\u001b\t\tYFC\u0002U\u0003;RA!a\u0018\u0002b\u0005!1m\u001c:f\u0015\u0011\t\u0019'!\u001a\u0002\u00155L7M]8nKR,'O\u0003\u0002\u0002h\u0005\u0011\u0011n\\\u0005\u0005\u0003W\nYFA\u0003US6,G-\u0001\u000bqe\u0016\f%o\u00195jm\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003cR3\u0001\\A:W\t\t)\b\u0005\u0003\u0002x\u0005}TBAA=\u0015\u0011\tY(! \u0002\u0013Ut7\r[3dW\u0016$'B\u0001+(\u0013\u0011\t\t)!\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bqe\u0016\f%o\u00195jm\u0016$C-\u001a4bk2$HeM\u0001'aJ,\u0017I]2iSZ,\u0017J\\1di&4XMU3mK\u0006\u001cXm]%o\u0005\u0006\u001c7n\u001a:pk:$\u0017A\u00079sK\u0006\u00138\r[5wK&s\u0017m\u0019;jm\u0016\u0014V\r\\3bg\u0016\u001cHcA9\u0002\f\"A\u0011Q\u0012\f\u0011\u0002\u0003\u0007q0\u0001\u0003qC\u001e,\u0007f\u0001\f\u0002\u0012B!\u00111SAK\u001b\t\ti(\u0003\u0003\u0002\u0018\u0006u$a\u0002;bS2\u0014XmY\u0001%aJ,\u0017I]2iSZ,\u0017J\\1di&4XMU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0014\u0016\u0004\u007f\u0006M\u0014AB:vE6LG/\u0006\u0003\u0002$\u0006MFcA9\u0002&\"9\u0011q\u0015\rA\u0002\u0005%\u0016a\u00016pEB)a%a+\u00020&\u0019\u0011QV\u0014\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BAY\u0003gc\u0001\u0001B\u0004\u00026b\u0011\r!a.\u0003\u0003U\u000bB!!/\u0002@B\u0019a%a/\n\u0007\u0005uvEA\u0004O_RD\u0017N\\4\u0011\u0007\u0019\n\t-C\u0002\u0002D\u001e\u00121!\u00118z\u0003!\u0011XO\u001c8bE2,W\u0003BAe\u0003G$B!a3\u0002\\B!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017\u0001\u00027b]\u001eT!!!6\u0002\t)\fg/Y\u0005\u0005\u00033\fyM\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\ti.\u0007a\u0001\u0003?\fAAY8esB)a%a+\u0002bB!\u0011\u0011WAr\t\u001d\t),\u0007b\u0001\u0003oC3\u0001AAt!\u0011\tI/a<\u000e\u0005\u0005-(bAAw3\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005E\u00181\u001e\u0002\b'\u0016\u0014h/[2fQ\r\u0001\u0011Q\u001f\t\u0005\u0003O\t90\u0003\u0003\u0002z\u0006%\"!D#wK:$H*[:uK:,'\u000f")
public class PreArchiveService
implements XlrServiceLifecycle {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    @Qualifier(value="pre-archiving")
    private final RestartableScheduledExecutorService preArchivingExecutor;
    private boolean enabled;
    private boolean catchingUp;
    private Enumeration.Value state;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String serviceName() {
        return XlrServiceLifecycle.serviceName$(this);
    }

    @Override
    public void start() {
        XlrServiceLifecycle.start$(this);
    }

    @Override
    public void awaitStart() {
        XlrServiceLifecycle.awaitStart$(this);
    }

    @Override
    public void stop() {
        XlrServiceLifecycle.stop$(this);
    }

    @Override
    public void awaitStop() {
        XlrServiceLifecycle.awaitStop$(this);
    }

    @Override
    public boolean isRunning() {
        return XlrServiceLifecycle.isRunning$(this);
    }

    @Override
    public ServiceStatus serviceStatus() {
        return XlrServiceLifecycle.serviceStatus$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Enumeration.Value state() {
        return this.state;
    }

    @Override
    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public int getOrder() {
        return 46;
    }

    @Override
    public void doStart() {
        this.preArchivingExecutor.start();
        this.logger().trace((Function0 & Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().debug((Function0 & Serializable)() -> "PreArchiveService started.");
    }

    @Override
    public void doStop() {
        this.preArchivingExecutor.stop();
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        if (this.isRunning()) {
            this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
            return;
        }
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        if (this.isRunning()) {
            this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
            return;
        }
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled, boolean recoverIfExists) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    this.logger().info((Function0 & Serializable)() -> "Pre-archiving " + release);
                    $this.archivingService.preArchiveRelease(release);
                    this.logger().debug((Function0 & Serializable)() -> "Pre-archived " + release);
                }
                catch (Exception e) {
                    this.logger().warn((Function0 & Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable)() -> e);
                    if (!recoverIfExists) {
                        throw e;
                    }
                    if ($this.archivingService.exists(release.getId())) {
                        this.logger().debug((Function0 & Serializable)() -> "Removing " + release + " from Archive Database");
                        if ($this.archivingService.deletePreArchiveRelease(release.getId())) {
                            this.logger().debug((Function0 & Serializable)() -> "Pre-archiving again " + release);
                            this.preArchive(release, checkEnabled, false);
                        } else {
                            this.logger().debug((Function0 & Serializable)() -> "Removing failed " + release + " from Archive Database");
                        }
                    }
                    this.logger().debug((Function0 & Serializable)() -> "Release " + release + " does not exist in Archive Database", (Function0 & Serializable)() -> e);
                    throw e;
                }
            });
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Pre-archiving is disabled");
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public boolean preArchive$default$3() {
        return true;
    }

    private synchronized void preArchiveInactiveReleasesInBackground() {
        if (!this.catchingUp()) {
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
            return;
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable)() -> "Fetching page " + page + " (" + pageSize + " releases) for pre-archiving...");
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            ((IterableOnceOps)found.filter((Function1 & Serializable)release -> BoxesRunTime.boxToBoolean((boolean)this.archivingService.shouldArchive(release)))).foreach((Function1 & Serializable)x$1 -> {
                this.preArchive(x$1, false, this.preArchive$default$3());
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private <U> void submit(Function0<U> job) {
        if (this.preArchivingExecutor.isActive()) {
            try {
                this.preArchivingExecutor.submit(this.runnable(job));
            }
            catch (RejectedExecutionException e) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to submit a job to " + $this.preArchivingExecutor.name(), (Function0 & Serializable)() -> e);
            }
            return;
        }
        this.logger().warn((Function0 & Serializable)() -> "Pool " + $this.preArchivingExecutor.name() + " is " + $this.preArchivingExecutor.state() + ". Cannot process job.");
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public PreArchiveService(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig, @Qualifier(value="pre-archiving") RestartableScheduledExecutorService preArchivingExecutor) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        this.preArchivingExecutor = preArchivingExecutor;
        Logging.$init$((Logging)this);
        XlrServiceLifecycle.$init$(this);
        this.enabled = false;
        this.catchingUp = false;
    }
}

