/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.xlrelease.spring.configuration.DeferredMultipartConfigElement;
import jakarta.servlet.MultipartConfigElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Role;
import org.springframework.core.Ordered;

@Role(value=2)
public class MultipartElementBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
Ordered {
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServletRegistrationBean) {
            ServletRegistrationBean b = (ServletRegistrationBean)bean;
            b.setMultipartConfig((MultipartConfigElement)new DeferredMultipartConfigElement(this.beanFactory));
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

