/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.outage;

import com.p6spy.engine.outage.P6OutageLoadableOptions;
import com.p6spy.engine.outage.P6OutageOptionsMBean;
import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.option.P6OptionsRepository;
import java.util.HashMap;
import java.util.Map;
import javax.management.StandardMBean;

public class P6OutageOptions
extends StandardMBean
implements P6OutageLoadableOptions {
    public static final String OUTAGEDETECTIONINTERVAL = "outagedetectioninterval";
    public static final String OUTAGEDETECTION = "outagedetection";
    protected static final Map<String, String> defaults = new HashMap<String, String>();
    private final P6OptionsRepository optionsRepository;

    public P6OutageOptions(P6OptionsRepository optionsRepository) {
        super(P6OutageOptionsMBean.class, false);
        this.optionsRepository = optionsRepository;
    }

    @Override
    public Map<String, String> getDefaults() {
        return defaults;
    }

    @Override
    public void load(Map<String, String> options) {
        this.setOutageDetection(options.get(OUTAGEDETECTION));
        this.setOutageDetectionInterval(options.get(OUTAGEDETECTIONINTERVAL));
    }

    public static P6OutageLoadableOptions getActiveInstance() {
        return P6ModuleManager.getInstance().getOptions(P6OutageOptions.class);
    }

    @Override
    public boolean getOutageDetection() {
        return this.optionsRepository.get(Boolean.class, OUTAGEDETECTION);
    }

    @Override
    public void setOutageDetection(String outagedetection) {
        this.optionsRepository.set(Boolean.class, OUTAGEDETECTION, outagedetection);
    }

    @Override
    public void setOutageDetection(boolean outagedetection) {
        this.optionsRepository.set(Boolean.class, OUTAGEDETECTION, outagedetection);
    }

    @Override
    public long getOutageDetectionInterval() {
        return this.optionsRepository.get(Long.class, OUTAGEDETECTIONINTERVAL);
    }

    @Override
    public long getOutageDetectionIntervalMS() {
        return this.getOutageDetectionInterval() * 1000L;
    }

    @Override
    public void setOutageDetectionInterval(String outagedetectioninterval) {
        this.optionsRepository.set(Long.class, OUTAGEDETECTIONINTERVAL, outagedetectioninterval);
    }

    @Override
    public void setOutageDetectionInterval(long outagedetectioninterval) {
        this.optionsRepository.set(Long.class, OUTAGEDETECTIONINTERVAL, outagedetectioninterval);
    }

    static {
        defaults.put(OUTAGEDETECTION, Boolean.toString(false));
        defaults.put(OUTAGEDETECTIONINTERVAL, Long.toString(30L));
    }
}

