/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.scm.data.VersionsView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.form.CreateVersionForm;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReport;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReportMessage;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.VersioningStyle;
import com.xebialabs.xlrelease.versioning.ascode.scm.model.GitBranch;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Path(value="api/v1/folders/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\r5d\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0003BqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002B\\\u0001\u0011\u0005!\u0011\u0018\u0005\b\u0005\u001b\u0004A\u0011\u0001Bh\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005?DqA!<\u0001\t\u0003\u0011y\u000fC\u0004\u0004\f\u0001!\ta!\u0004\t\u000f\r\r\u0002\u0001\"\u0001\u0004&!911\u0007\u0001\u0005\u0002\rU\"\u0001\u0007$pY\u0012,'OV3sg&|g.\u001b8h%\u0016\u001cx.\u001e:dK*\u0011A$H\u0001\tS:$XM\u001d8bY*\u0011adH\u0001\u0004CBL'B\u0001\u0011\"\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002#G\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002I\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0003tY\u001a$$NC\u00013\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001b0\u0005\u001daunZ4j]\u001e\f\u0011\u0003]3s[&\u001c8/[8o\u0007\",7m[3s!\t9$(D\u00019\u0015\tIt$\u0001\u0005tK\u000e,(/\u001b;z\u0013\tY\u0004HA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\fqCZ8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKJ4\u0018nY3\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015aA:d[*\u0011!iQ\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005\u0011{\u0012A\u0003<feNLwN\\5oO&\u0011ai\u0010\u0002\u0018\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cVM\u001d<jG\u0016\fa\u0002\u001d:fm&,woU3sm&\u001cW\r\u0005\u0002?\u0013&\u0011!j\u0010\u0002\u001f\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u0004&/\u001a<jK^\u001cVM\u001d<jG\u0016\fADZ8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4BGR|'oU3sm&\u001cW\r\u0005\u0002N!6\taJ\u0003\u0002P\u0003\u00061\u0011m\u0019;peNL!!\u0015(\u00039\u0019{G\u000eZ3s-\u0016\u00148/[8oS:<\u0017i\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"R\u0001\u0016,X1f\u0003\"!\u0016\u0001\u000e\u0003mAQ!N\u0003A\u0002YBQ\u0001P\u0003A\u0002uBQaR\u0003A\u0002!CQaS\u0003A\u00021C#!B.\u0011\u0005q;W\"A/\u000b\u0005y{\u0016AC1o]>$\u0018\r^5p]*\u0011\u0001-Y\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u00117-A\u0003cK\u0006t7O\u0003\u0002eK\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001g\u0003\ry'oZ\u0005\u0003Qv\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0017\u001d,GoU3ui&twm\u001d\u000b\u0003WN\u0004\"\u0001\\9\u000e\u00035T!A\u00118\u000b\u0005\u0011{'B\u00019 \u0003\u0019!w.\\1j]&\u0011!/\u001c\u0002\u0019\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cV\r\u001e;j]\u001e\u001c\b\"\u0002;\u0007\u0001\u0004)\u0018\u0001\u00034pY\u0012,'/\u00133\u0011\u0005YlhBA<|!\tA\u0018&D\u0001z\u0015\tQX%\u0001\u0004=e>|GOP\u0005\u0003y&\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0\u000b\u0015\bg\u0006\r\u0011qCA\r!\u0011\t)!a\u0005\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t!A]:\u000b\t\u00055\u0011qB\u0001\u0003oNT!!!\u0005\u0002\u000f)\f7.\u0019:uC&!\u0011QCA\u0004\u0005%\u0001\u0016\r\u001e5QCJ\fW.A\u0003wC2,X-I\u0001uQ\r1\u0011Q\u0004\t\u0005\u0003\u000b\ty\"\u0003\u0003\u0002\"\u0005\u001d!aA$F)\":a!!\n\u0002\u0018\u0005-\u0002\u0003BA\u0003\u0003OIA!!\u000b\u0002\b\t!\u0001+\u0019;iC\t\ti#A\u000e0w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSpL\u0001\u000fkB$\u0017\r^3TKR$\u0018N\\4t)\u0015Y\u00171GA\u001c\u0011\u0015!x\u00011\u0001vQ!\t\u0019$a\u0001\u0002\u0018\u0005e\u0001BBA\u001d\u000f\u0001\u00071.\u0001\u0004d_:4\u0017n\u001a\u0015\u0004\u000f\u0005u\u0002\u0003BA\u0003\u0003\u007fIA!!\u0011\u0002\b\t\u0019\u0001+\u0016+)\u000f\u001d\t)#a\u0006\u0002,\u0005qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BA%\u0003\u001f\u00022\u0001KA&\u0013\r\ti%\u000b\u0002\u0005+:LG\u000fC\u0003u\u0011\u0001\u0007Q\u000f\u000b\u0005\u0002P\u0005\r\u0011qCA\rQ\rA\u0011Q\u000b\t\u0005\u0003\u000b\t9&\u0003\u0003\u0002Z\u0005\u001d!A\u0002#F\u0019\u0016#V\tK\u0004\t\u0003K\t9\"a\u000b\u0002\u0017\u001d,GOV3sg&|gn\u001d\u000b\u0007\u0003C\ny'a\u001d\u0011\t\u0005\r\u00141N\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005!A-\u0019;b\u0015\t\u0001u$\u0003\u0003\u0002n\u0005\u0015$\u0001\u0004,feNLwN\\:WS\u0016<\b\"\u0002;\n\u0001\u0004)\b\u0006CA8\u0003\u0007\t9\"!\u0007\t\u000f\u0005U\u0014\u00021\u0001\u0002x\u0005aa-\u001a;dQ\u000eC\u0017M\\4fgB\u0019\u0001&!\u001f\n\u0007\u0005m\u0014FA\u0004C_>dW-\u00198)\u0011\u0005M\u0014qPA\f\u0003\u000b\u0003B!!\u0002\u0002\u0002&!\u00111QA\u0004\u00051!UMZ1vYR4\u0016\r\\;fC\t\t9)A\u0003gC2\u001cX\r\u000b\u0005\u0002t\u0005-\u0015qCAI!\u0011\t)!!$\n\t\u0005=\u0015q\u0001\u0002\u000b#V,'/\u001f)be\u0006l\u0017EAA;Q\rI\u0011Q\u0004\u0015\b\u0013\u0005\u0015\u0012qCALC\t\tI*A\u00120w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSp\f<feNLwN\\:\u0002\u001d\u001d,G/\u00117m\u0005J\fgn\u00195fgR1\u0011qTA_\u0003\u0003\u0004b!!)\u0002,\u0006Ef\u0002BAR\u0003Os1\u0001_AS\u0013\u0005Q\u0013bAAUS\u00059\u0001/Y2lC\u001e,\u0017\u0002BAW\u0003_\u00131aU3r\u0015\r\tI+\u000b\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011qW \u0002\u000b5|G-\u001a7\n\t\u0005m\u0016Q\u0017\u0002\n\u000f&$(I]1oG\"DQ\u0001\u001e\u0006A\u0002UD\u0003\"!0\u0002\u0004\u0005]\u0011\u0011\u0004\u0005\u0007\u0003\u0007T\u0001\u0019A;\u0002\u0011\r|gNZ5h\u0013\u0012D\u0003\"!1\u0002\f\u0006]\u0011qY\u0011\u0003\u0003\u0007D3ACA\u000fQ\u001dQ\u0011QEA\f\u0003\u001b\f#!a4\u0002G=Zhm\u001c7eKJLEM\u000f\u0018+\r>dG-\u001a:\\=>jSLK?0EJ\fgn\u00195fg\u0006i1M]3bi\u00164VM]:j_:$b!!6\u0002\\\u0006}\u0007\u0003BA2\u0003/LA!!7\u0002f\tYa+\u001a:tS>t\u0017J\u001c4p\u0011\u0015!8\u00021\u0001vQ!\tY.a\u0001\u0002\u0018\u0005e\u0001bBAq\u0017\u0001\u0007\u00111]\u0001\fm\u0016\u00148/[8o\r>\u0014X\u000e\u0005\u0003\u0002f\u0006-XBAAt\u0015\r\tI/Q\u0001\u0005M>\u0014X.\u0003\u0003\u0002n\u0006\u001d(!E\"sK\u0006$XMV3sg&|gNR8s[\"\u001a1\"!=\u0011\t\u0005\u0015\u00111_\u0005\u0005\u0003k\f9A\u0001\u0003Q\u001fN#\u0006fB\u0006\u0002&\u0005]\u0011qS\u0001\rCB\u0004H.\u001f,feNLwN\u001c\u000b\u0007\u0003\u0013\niP!\u0001\t\u000bQd\u0001\u0019A;)\u0011\u0005u\u00181AA\f\u00033AaAa\u0001\r\u0001\u0004)\u0018a\u0002<feNLwN\u001c\u0015\t\u0005\u0003\t\u0019!a\u0006\u0003\b\u0005\u0012!1\u0001\u0015\u0004\u0019\u0005E\bf\u0002\u0007\u0002&\u0005]!QB\u0011\u0003\u0005\u001f\tagL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u001a:tS>t7oL>wKJ\u001c\u0018n\u001c8;])jx&\u00199qYf\fa\u0002\u001d:fm&,woQ;se\u0016tG\u000fF\u0003v\u0005+\u0011I\u0002C\u0003u\u001b\u0001\u0007Q\u000f\u000b\u0005\u0003\u0016\u0005\r\u0011qCA\r\u0011\u0019\u0011Y\"\u0004a\u0001k\u0006Aa-\u001b7f]\u0006lW\r\u000b\u0003\u0003\u001a\t}\u0001\u0003BA\u0003\u0005CIAAa\t\u0002\b\t9QI\\2pI\u0016$\u0007\u0006\u0003B\r\u0003\u0017\u000b9Ba\n\"\u0005\tm\u0001fA\u0007\u0002\u001e!:QB!\f\u0002\u0018\tM\u0002\u0003BA\u0003\u0005_IAA!\r\u0002\b\tA\u0001K]8ek\u000e,7\u000f\f\u0002\u00036\u0005\u0012!qG\u0001\u000ei\u0016DHo\f<oI:J\u0018-\u001c7)\u000f5\t)#a\u0006\u0003<\u0005\u0012!QH\u0001#_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018qe\u00164\u0018.Z<\u0002\u001dA\u0014XM^5foZ+'o]5p]R9QOa\u0011\u0003H\t-\u0003\"\u0002;\u000f\u0001\u0004)\b\u0006\u0003B\"\u0003\u0007\t9\"!\u0007\t\r\t\ra\u00021\u0001vQ!\u00119%a\u0001\u0002\u0018\t\u001d\u0001B\u0002B\u000e\u001d\u0001\u0007Q\u000f\u000b\u0003\u0003L\t}\u0001\u0006\u0003B&\u0003\u0017\u000b9Ba\n)\u00079\ti\u0002K\u0004\u000f\u0005[\t9B!\u0016-\u0005\tU\u0002f\u0002\b\u0002&\u0005]!\u0011L\u0011\u0003\u00057\n\u0001hL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u001a:tS>t7oL>wKJ\u001c\u0018n\u001c8;])jx\u0006\u001d:fm&,w/A\u000bhKR4VM]:j_:,GMR5mK:\u000bW.Z:\u0015\r\t\u0005$q\rB6!\u0015\t\tKa\u0019v\u0013\u0011\u0011)'a,\u0003\t1K7\u000f\u001e\u0005\u0006i>\u0001\r!\u001e\u0015\t\u0005O\n\u0019!a\u0006\u0002\u001a!1!1A\bA\u0002UD\u0003Ba\u001b\u0002\u0004\u0005]!q\u0001\u0015\u0004\u001f\u0005u\u0001fB\b\u0002&\u0005]!1O\u0011\u0003\u0005k\naiL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u001a:tS>t7oL>wKJ\u001c\u0018n\u001c8;])jxfZ3u-\u0016\u00148/[8oK\u00124\u0015\u000e\\3OC6,7/\u0001\u0010hKR\u001cUO\u001d:f]R4VM]:j_:\f'\r\\3GS2,g*Y7fgR!!\u0011\rB>\u0011\u0015!\b\u00031\u0001vQ!\u0011Y(a\u0001\u0002\u0018\u0005e\u0001f\u0001\t\u0002\u001e!:\u0001#!\n\u0002\u0018\t\r\u0015E\u0001BC\u0003Iz3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_\u001d,GOV3sg&|g.\u00192mK\u001aKG.\u001a(b[\u0016\u001c\u0018a\u00043fY\u0016$X\rT8dC2\u0014V\r]8\u0015\r\u0005%#1\u0012BH\u0011\u0015!\u0018\u00031\u0001vQ!\u0011Y)a\u0001\u0002\u0018\u0005e\u0001b\u0002BI#\u0001\u0007\u0011qO\u0001\fG2,8\u000f^3s/&$W\r\u000b\u0005\u0003\u0010\u0006}\u0014qCACQ!\u0011y)a#\u0002\u0018\t]\u0015E\u0001BIQ\r\t\u0012Q\u000b\u0015\b#\u0005\u0015\u0012q\u0003BOC\t\u0011y*\u0001\u00170w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSp\f3fY\u0016$X-\f7pG\u0006dWF]3q_\u0006q!/Z:fi2{7-\u00197SKB|GCBA%\u0005K\u0013I\u000bC\u0003u%\u0001\u0007Q\u000f\u000b\u0005\u0003&\u0006\r\u0011qCA\r\u0011\u001d\u0011\tJ\u0005a\u0001\u0003oB\u0003B!+\u0002\u0000\u0005]\u0011Q\u0011\u0015\t\u0005S\u000bY)a\u0006\u0003\u0018\"\u001a!#!\u0010)\u000fI\t)#a\u0006\u00034\u0006\u0012!QW\u0001,_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018sKN,G/\f7pG\u0006dWF]3q_\u0006ya/\u00197jI\u0006$XmQ;se\u0016tG\u000f\u0006\u0003\u0003<\n\u0005\u0007\u0003BAs\u0005{KAAa0\u0002h\n\u0001b+\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0005\u0006iN\u0001\r!\u001e\u0015\t\u0005\u0003\f\u0019!a\u0006\u0002\u001a!\u001a1#!\b)\u000fM\t)#a\u0006\u0003J\u0006\u0012!1Z\u0001$_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wC2LG-\u0019;f\u0003U9W\r\u001e,bY&$\u0017\r^5p]6+7o]1hKN$BAa/\u0003R\")A\u000f\u0006a\u0001k\"B!\u0011[A\u0002\u0003/\tI\u0002K\u0002\u0015\u0003;As\u0001FA\u0013\u0003/\u0011I.\t\u0002\u0003\\\u0006qsf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>2\u0018\r\\5eCRLwN\\\u0017nKN\u001c\u0018mZ3t\u0003U\u0019X\r\u001e,bY&$\u0017\r^5p]6+7o]1hKN$b!!\u0013\u0003b\n\u0015\b\"\u0002;\u0016\u0001\u0004)\b\u0006\u0003Bq\u0003\u0007\t9\"!\u0007\t\u000f\t\u001dX\u00031\u0001\u0003<\u0006\u0001b/\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0015\u0004+\u0005u\u0002fB\u000b\u0002&\u0005]!\u0011\\\u0001\u0015O\u0016$h+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\u0015\r\tE(q\u001fB~!\u0011\t)Oa=\n\t\tU\u0018q\u001d\u0002\u0018-\u0006d\u0017\u000eZ1uS>t'+\u001a9peRlUm]:bO\u0016DQ\u0001\u001e\fA\u0002UD\u0003Ba>\u0002\u0004\u0005]\u0011\u0011\u0004\u0005\u0007\u0005{4\u0002\u0019A;\u0002\u00135,7o]1hK&#\u0007\u0006\u0003B~\u0003\u0007\t9b!\u0001\"\u0005\tu\bf\u0001\f\u0002\u001e!:a#!\n\u0002\u0018\r\u001d\u0011EAB\u0005\u0003Iz3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_5,7o]1hK>ZX.Z:tC\u001e,\u0017\n\u001a\u001e/Uu|\u0013aG:fiZ\u000bG.\u001b3bi&|g.T3tg\u0006<Wm]*uCR,8\u000f\u0006\u0005\u0002J\r=11CB\f\u0011\u0015!x\u00031\u0001vQ!\u0019y!a\u0001\u0002\u0018\u0005e\u0001B\u0002B\u007f/\u0001\u0007Q\u000f\u000b\u0005\u0004\u0014\u0005\r\u0011qCB\u0001\u0011\u001d\u0019Ib\u0006a\u0001\u0005c\f\u0011C^1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fQ\r9\u0012Q\b\u0015\b/\u0005\u0015\u0012qCB\u0010C\t\u0019\t#\u0001\u001d0w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSpL7fgN\fw-Z\u0018|[\u0016\u001c8/Y4f\u0013\u0012TdFK?0kB$\u0017\r^3\u0002\u0019\rdW-\u0019:TK\u000e\u0014X\r^:\u0015\t\u0005%3q\u0005\u0005\u0006ib\u0001\r!\u001e\u0015\t\u0007O\t\u0019!a\u0006\u0002\u001a!\u001a\u0001$!\u0016)\u000fa\t)#a\u0006\u00040\u0005\u00121\u0011G\u0001)_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018dY\u0016\f'/L:fGJ,Go]\u0001\u0014O\u0016$h+\u001a:tS>t\u0017N\\4TifdWm]\u000b\u0003\u0007o\u0001b!!)\u0003d\re\u0002c\u0001 \u0004<%\u00191QH \u0003\u001fY+'o]5p]&twm\u0015;zY\u0016D3!GA\u000fQ\u001dI\u0012QEA\f\u0007\u0007\n#a!\u0012\u0002\u000f=\u001aH/\u001f7fg\":\u0001!!\n\u0002\u0018\r%\u0013EAB&\u0003e\t\u0007/[\u0018wc=2w\u000e\u001c3feN|c/\u001a:tS>t\u0017N\\4)\u000f\u0001\u0011i#a\u0006\u0004P1\u00121\u0011K\u0011\u0003\u0007'\n\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\u000f\u0001\u00199&a\u0006\u0004^A!\u0011QAB-\u0013\u0011\u0019Y&a\u0002\u0003\u0011\r{gn];nKNd#a!\u0015)\u0007\u0001\u0019\t\u0007\u0005\u0003\u0004d\r%TBAB3\u0015\r\u00199gY\u0001\u000bgR,'/Z8usB,\u0017\u0002BB6\u0007K\u0012!bQ8oiJ|G\u000e\\3s\u0001")
public class FolderVersioningResource
implements Logging {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningResource folderVersioningResource = this;
        synchronized (folderVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)((Object)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        config.setFolderId(folderId);
        return this.folderVersioningActorService.createOrUpdateSettings(config);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionsView getVersions(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="fetchChanges") boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = fetchChanges ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/branches")
    public scala.collection.immutable.Seq<GitBranch> getAllBranches(@PathParam(value="folderId") String folderId, @QueryParam(value="configId") String configId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getAllBranches(configId);
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionInfo createVersion(@PathParam(value="folderId") String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.name(), versionForm.description());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/apply")
    public void applyVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        this.folderVersioningService.applyVersion(folderId, version);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/preview")
    public String previewCurrent(@PathParam(value="folderId") String folderId, @Encoded @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, filename);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/preview")
    public String previewVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version, @Encoded @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/getVersionedFileNames")
    public List<String> getVersionedFileNames(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionedFileNames(folderId, version);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/getVersionableFileNames")
    public List<String> getCurrentVersionableFileNames(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionableFileNames(folderId);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/delete-local-repo")
    public void deleteLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, clusterWide);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/reset-local-repo")
    public void resetLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, clusterWide);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validate")
    public ValidationReport validateCurrent(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public ValidationReport getValidationMessages(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public void setValidationMessages(@PathParam(value="folderId") String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.warnings()).asScala().toSeq());
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/")
    public ValidationReportMessage getValidationMessage(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/update")
    public void setValidationMessagesStatus(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/clear-secrets")
    public void clearSecrets(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    @GET
    @Path(value="/styles")
    public List<VersioningStyle> getVersioningStyles() {
        return this.folderVersioningService.getVersioningStyles();
    }

    @Autowired
    public FolderVersioningResource(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        Logging.$init$((Logging)this);
    }
}

