import React from 'react';
import { AvatarWithName } from '@xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '@xlr-ui/app/types';
import { RELEASE_LOGO_SVG, SYSTEM_USERS } from '../constants';

export interface ActivityLogsUserProps {
    avatarSize?: 'small' | 'medium' | 'large';
    isNameHidden?: boolean;
    title: string;
    user: User;
}

export const ActivityLogsUser = ({ avatarSize, isNameHidden = false, title, user }: ActivityLogsUserProps) => {
    const { username } = user;
    const avatarImgSrc = SYSTEM_USERS.includes(username) ? RELEASE_LOGO_SVG : undefined;
    return <AvatarWithName avatarImgSrc={avatarImgSrc} avatarSize={avatarSize} id={username} isNameHidden={isNameHidden} title={title} />;
};
