import React from 'react';
import { DotInputText } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { FilterDate, FilterDateProps } from './filter-date.component';

describe('FilterDate', () => {
    let wrapper: ReactWrapper;

    const defaultProps: FilterDateProps = { inputId: 'my-id', onChange: jest.fn(), value: 1 };

    const getDateInput = () => wrapper.find(DotInputText);

    const mount = (props: FilterDateProps = defaultProps) => {
        wrapper = mountWithTheme(<FilterDate {...props} />);
    };

    it('should have default props', () => {
        mount();
        const dateInputProps = getDateInput().props();
        expect(dateInputProps.id).toBe('my-id');
        expect(dateInputProps.name).toBe('my-id');
        expect(dateInputProps.type).toBe('datetime-local');
    });

    it('should parse the value number to date', () => {
        mount();
        const dateInputProps = getDateInput().props();
        expect(dateInputProps.value).toBe('1970-01-01T01:00');
    });

    it('should convert the date to number', () => {
        mount();
        getDateInput().invoke('onChange')?.({ target: { value: '2021-01-01T00:00' } } as React.ChangeEvent<HTMLInputElement>);
        expect(defaultProps.onChange).toHaveBeenCalledWith(1609455600000);
    });
});
