import { RootState } from '@xlr-ui/app/js/store.types';
import { ConnectionServerMetadata, LiveDeploymentConfigData, LiveDeploymentConfigPage } from '../deployment-server.types';
import { DeploymentServerState } from './deployment-server.reducer';

export const getDeploymentServerState = (state: RootState): DeploymentServerState => state.folderDeploymentServers;
export const getLiveDeploymentConfigsSelector = (state: RootState): Array<LiveDeploymentConfigData> => getDeploymentServerState(state).liveDeploymentConfigs;
export const getLiveDeploymentConfigsCountSelector = (state: RootState): number => getDeploymentServerState(state).liveDeploymentConfigsCount;
export const getIsLoadingSelector = (state: RootState): boolean => getDeploymentServerState(state).isLoading;
export const getConnectionServerMetadata = (state: RootState): Array<ConnectionServerMetadata> => getDeploymentServerState(state).connectionServerMetadata;
export const getConfigurationCondition = (state: RootState): string => getDeploymentServerState(state).configurationCondition;
export const getConfigurationPage = (state: RootState): LiveDeploymentConfigPage => getDeploymentServerState(state).configurationPage;
