import { labelsState, initialState } from './labels.reducer';
import { labels } from '../__mocks__/environment-list.mocks';
const { setLabels, searchLabels, saveLabel, deleteLabel } = labelsState.actions;

describe('Labels reducer', () => {
    it('should have initial state', () => {
        expect(labelsState.name).toBe('labelsState');
        expect(labelsState.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set labels', () => {
        const state = labelsState.reducer(initialState, setLabels(labels));
        expect(state.labelList).toStrictEqual(labels);
    });

    it('search should not update state', () => {
        const state = labelsState.reducer(initialState, searchLabels(''));
        expect(state).toStrictEqual(initialState);
    });

    it('save should not update state', () => {
        const state = labelsState.reducer(initialState, saveLabel({ id: '1', color: '', title: 'name' }));
        expect(state).toStrictEqual(initialState);
    });

    it('delete should not update state', () => {
        const state = labelsState.reducer(initialState, deleteLabel({ id: '1', color: '', title: 'name' }));
        expect(state).toStrictEqual(initialState);
    });
});
