import React, { useState } from 'react';
import includes from 'lodash/includes';
import LabelItem, { SkinType } from '../../shared/label/label-item';
import { LabelModalFormComponent } from '../label/label-modal-form-component';
import { initEnvLabel } from '../label/label-list-component';

import './sidebar-label-list.less';
import { Label } from '../../../application-list.types';
import { DotIcon, DotInputText } from '@digital-ai/dot-components';

const filterLabelFieldMetadata = { placeholder: 'Filter by label...' };

export interface SidebarLabelListProps {
    labelList: Array<Label>;
    onClickLabel: (label: Label) => void;
    saveLabel: (label: Label) => void;
}
export const SidebarLabelList = ({ labelList, onClickLabel, saveLabel }: SidebarLabelListProps) => {
    const [envLabel, setEnvLabel] = useState(initEnvLabel);
    const [modalIsOpen, setModalOpen] = useState(false);
    const [labelFilterText, setLabelFilterText] = React.useState('');

    const onNameChange = (name: string) => {
        setLabelFilterText(name);
    };

    const filterLabels = (environmentLabel: Label) => {
        return includes(environmentLabel.title.toLowerCase(), labelFilterText.toLowerCase());
    };

    const showCreateLabelModal = () => {
        setModalOpen(true);
        setEnvLabel(initEnvLabel);
    };

    const onConfirmEditModal = (environmentLabel: Label, isCreateAnother: boolean) => {
        setModalOpen(false);
        saveLabel({ id: '', title: environmentLabel.title, color: environmentLabel.color });

        setModalOpen(isCreateAnother);
        setEnvLabel(initEnvLabel);
    };

    const onCancelEditModal = () => {
        setModalOpen(false);
        setEnvLabel(initEnvLabel);
    };

    const renderLabels = () => {
        return labelList
            .filter((envLbl: Label) => filterLabels(envLbl))
            .map((envLbl: Label) => <LabelItem envLabel={envLbl} key={envLbl.id} onClickLabel={onClickLabel} skin={SkinType.Plus} />);
    };

    return (
        <React.Fragment>
            <div className="environment-label-sidebar">
                <div className="header">
                    <h4 className="page-title">
                        Labels
                        <button className="button pull-right" onClick={showCreateLabelModal} type="button">
                            New label
                        </button>
                    </h4>
                    <DotInputText
                        id={'label-search'}
                        name={'label-search'}
                        onChange={(e) => onNameChange(e.target.value)}
                        placeholder={filterLabelFieldMetadata.placeholder}
                        startIcon={<DotIcon iconId="search" />}
                    />
                </div>
                <div className="environment-sidebar-label-list">{renderLabels()}</div>
            </div>

            <LabelModalFormComponent
                labelModel={envLabel}
                modalIsOpen={modalIsOpen}
                onCancelModal={onCancelEditModal}
                onConfirmModal={onConfirmEditModal}
                onOpenDelete={onCancelEditModal}
            />
        </React.Fragment>
    );
};
