import React, { ChangeEventHandler, KeyboardEvent } from 'react';
import { DotIcon, DotInputText } from '@digital-ai/dot-components';
import classNames from 'classnames';

export interface SearchProps {
    defaultValue?: string;
    inputId?: string;
    inputPlaceholder?: string;
    inputRef?: React.RefObject<HTMLInputElement>;
    label?: string;
    onFilterChange?: ChangeEventHandler<HTMLInputElement | HTMLTextAreaElement>;
    onKeyDown?: (event: KeyboardEvent) => void;
    searchClassNames: string[];
}

export const Search = ({
    defaultValue = '',
    inputId = 'search-input',
    inputRef,
    label,
    onFilterChange,
    onKeyDown,
    searchClassNames = [],
    inputPlaceholder = '',
}: SearchProps) => {
    return (
        <div className={classNames('search', ...searchClassNames)}>
            <DotIcon iconId="search" />
            <DotInputText
                className="search-input"
                defaultValue={defaultValue}
                disabled={false}
                fullWidth={true}
                id={inputId}
                inputRef={inputRef}
                label={label}
                name="search-input"
                onChange={onFilterChange}
                onKeyDown={onKeyDown}
                placeholder={inputPlaceholder}
            />
        </div>
    );
};
