import urllib
import sys
import json

from jenkins import JenkinsServer

from jenkins.oidc_helper import OidcHelper

jenkinsURL = jenkinsServer['url']

if jenkinsURL.endswith("/"):
    job = 'job/'
else:
    job = '/job/'

jobContext = job + urllib.quote(jobName) + '/'
contentType = 'application/json'
endpoint = jobContext + 'build?delay=0'

# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)
#Headers for OIDC token if enabled
if jenkinsServer['useOidc']:
    OidcHelper(jenkinsServer).set_token_headers(headers)

# To Check if the JOB is Multibranch Pipeline or NOT.
job_response = request.get(jobContext + 'api/json', contentType=contentType, headers=headers)
job_info = json.loads(job_response.response)
job_class = ""
if "_class" in job_info:
    job_class = job_info["_class"]
    if job_class  != "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject":
        raise Exception(" ' {} ' is not a Multibranch Pipeline Job.".format(jobName))
else:
    err_msg = "Failed to retrieve job information"
    if "message" in job_info:
        err_msg = job_info['message']
    if "status" in job_info:
        err_msg = "{} : {}".format(err_msg, job_info['status'])
    raise Exception(err_msg)

# Scan Multibranch Pipeline
response = request.post(endpoint, '', contentType=contentType, headers=headers)

if response.isSuccessful():
    print "Multibranch pipeline scan triggered successfully."
else:
    raise Exception("Failed to trigger multibranch pipeline scan: {}".format(response.errorDump()))
