/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.api.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardService;
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView;
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Path(value="/dashboards")
@Controller
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\t\u0012\u0001\u0001B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u00079\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011}\u0002!Q1A\u0005\u0004\u0001C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006G\u0002!\t\u0001\u001a\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002|\u0001!\t!! \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\n\tB)Y:iE>\f'\u000f\u001a*fg>,(oY3\u000b\u0005I\u0019\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q)\u0012aA1qS*\u0011acF\u0001\nI\u0006\u001c\bNY8be\u0012T!\u0001G\r\u0002\u000fAdWoZ5og*\u0011!dG\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001H\u000f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\teCND'm\\1sIN+'O^5dKV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-+\u000591/\u001a:wS\u000e,\u0017B\u0001\u0018,\u0005A!\u0015m\u001d5c_\u0006\u0014HmU3sm&\u001cW-A\teCND'm\\1sIN+'O^5dK\u0002\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z+\u0005\u0011\u0004C\u0001\u00164\u0013\t!4FA\tECND'm\\1sIN+7-\u001e:jif\f!\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;zA\u000592m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111(G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001f;\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\rd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0002\nAb\u001c2kK\u000e$X*\u00199qKJ,\u0012!\u0011\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003\r\u001e\u000bqA[1dWN|gN\u0003\u0002I;\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003\u0015\u000e\u0013Ab\u00142kK\u000e$X*\u00199qKJ\fQb\u001c2kK\u000e$X*\u00199qKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0003O!F\u00136\u000b\u0005\u0002P\u00015\t\u0011\u0003C\u0003(\u0013\u0001\u0007\u0011\u0006C\u00031\u0013\u0001\u0007!\u0007C\u00037\u0013\u0001\u000f\u0001\bC\u0003@\u0013\u0001\u000f\u0011\t\u000b\u0002\n+B\u0011a+Y\u0007\u0002/*\u0011\u0001,W\u0001\u000bC:tw\u000e^1uS>t'B\u0001.\\\u0003\u001d1\u0017m\u0019;pefT!\u0001X/\u0002\u000b\t,\u0017M\\:\u000b\u0005y{\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0001\f1a\u001c:h\u0013\t\u0011wKA\u0005BkR|w/\u001b:fI\u000611/Z1sG\"$B!Z:\u0002\u001cA\u0019am[7\u000e\u0003\u001dT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\tawM\u0001\u0003MSN$\bC\u00018r\u001b\u0005y'B\u00019\u0016\u0003\u00151\u0018.Z<t\u0013\t\u0011xNA\u0007ECND'm\\1sIZKWm\u001e\u0005\u0006i*\u0001\r!^\u0001\ta\u0006\u0014XM\u001c;JIB\u0011a/ \b\u0003on\u0004\"\u0001_\u0012\u000e\u0003eT!A_\u0010\u0002\rq\u0012xn\u001c;?\u0013\ta8%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?$Q\u001d\u0019\u00181AA\f\u00033\u0001B!!\u0002\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0002sg*!\u0011QBA\b\u0003\t98O\u0003\u0002\u0002\u0012\u00059!.Y6beR\f\u0017\u0002BA\u000b\u0003\u000f\u0011!\"U;fef\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u0005!\bBBA\u000f\u0015\u0001\u0007Q/A\u0003uSRdW\r\u000b\u0005\u0002\u001c\u0005\r\u0011qCA\u0011C\t\ti\u0002K\u0002\u000b\u0003K\u0001B!!\u0002\u0002(%!\u0011\u0011FA\u0004\u0005\r9U\tV\u0001\rO\u0016$H)Y:iE>\f'\u000f\u001a\u000b\u0006[\u0006=\u0012Q\b\u0005\u0007\u0003cY\u0001\u0019A;\u0002\u0017\u0011\f7\u000f\u001b2pCJ$\u0017\n\u001a\u0015\t\u0003_\t)$a\u0006\u0002<A!\u0011QAA\u001c\u0013\u0011\tI$a\u0002\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017EAA\u0019\u0011\u001d\tyd\u0003a\u0001\u0003\u0003\nqA]3ge\u0016\u001c\b\u000eE\u0002#\u0003\u0007J1!!\u0012$\u0005\u001d\u0011un\u001c7fC:D\u0003\"!\u0010\u0002\u0004\u0005]\u0011\u0011J\u0011\u0003\u0003\u007fA3aCA\u0013Q\u001dY\u0011qJA\f\u0003+\u0002B!!\u0002\u0002R%!\u00111KA\u0004\u0005\u0011\u0001\u0016\r\u001e5\"\u0005\u0005]\u0013AL>eCND'm\\1sI&#'(\u00119qY&\u001c\u0017\r^5p]Nt#\u0006 \u0018+\t\u0006\u001c\bNY8be\u0012\\flL\u0017^Uu\fq\"\u001e9eCR,G)Y:iE>\f'\u000f\u001a\u000b\u0006[\u0006u\u0013\u0011\r\u0005\u0007\u0003ca\u0001\u0019A;)\u0011\u0005u\u0013QGA\f\u0003wAQA\u0006\u0007A\u00025D3\u0001DA3!\u0011\t)!a\u001a\n\t\u0005%\u0014q\u0001\u0002\u0004!V#\u0006f\u0002\u0007\u0002P\u0005]\u0011QK\u0001\u0010GJ,\u0017\r^3ECND'm\\1sIR\u0019Q.!\u001d\t\u000bYi\u0001\u0019A7)\u00075\t)\b\u0005\u0003\u0002\u0006\u0005]\u0014\u0002BA=\u0003\u000f\u0011A\u0001U(T)\u0006yA-\u001a7fi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002\u0000\u0005\u0015\u0005c\u0001\u0012\u0002\u0002&\u0019\u00111Q\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003cq\u0001\u0019A;)\u0011\u0005\u0015\u0015QGA\f\u0003wA3ADAF!\u0011\t)!!$\n\t\u0005=\u0015q\u0001\u0002\u0007\t\u0016cU\tV#)\u000f9\ty%a\u0006\u0002V\u0005iA.[:u)\u0016l\u0007\u000f\\1uKN$B!a&\u00020B!am[AM!\u0011\tY*a+\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bqA]3gY\u0016\u001cGOC\u0002\u0015\u0003GSA!!*\u0002(\u00061\u0001\u000f\\;hS:T1!!+\u001c\u0003!!W\r\u001d7ps&$\u0018\u0002BAW\u0003;\u0013!\u0002R3tGJL\u0007\u000f^8s\u0011\u001d\t\tl\u0004a\u0001\u0003g\u000bQa]2pa\u0016\u0004B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003s+\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002>\u0006]&!\u0003+jY\u0016\u001c6m\u001c9fQ!\ty+a\u0001\u0002\u0018\u0005\u0005\u0017EAAYQ!\ty+!2\u0002\u0018\u0005-\u0007\u0003BA\u0003\u0003\u000fLA!!3\u0002\b\taA)\u001a4bk2$h+\u00197vK\u0006\u0012\u0011QZ\u0001\b%\u0016cU)Q*FQ\ry\u0011Q\u0005\u0015\b\u001f\u0005=\u0013qCAjC\t\t).\u0001\u00060i\u0016l\u0007\u000f\\1uKNDs\u0001AA(\u0003/\tI.\t\u0002\u0002\\\u0006Yq\u0006Z1tQ\n|\u0017M\u001d3tQ\r\u0001\u0011q\u001c\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q]/\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002j\u0006\r(AC\"p]R\u0014x\u000e\u001c7fe\":\u0001!!<\u0002\u0018\u0005M\b\u0003BA\u0003\u0003_LA!!=\u0002\b\tA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002v\u0006\u0012\u0011q_\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:Ds\u0001AA~\u0003/\u0011\t\u0001\u0005\u0003\u0002\u0006\u0005u\u0018\u0002BA\u0000\u0003\u000f\u0011\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003k\u0004")
public class DashboardResource {
    private final DashboardService dashboardService;
    private final DashboardSecurity dashboardSecurity;
    private final ConfigurationRepository configurationRepository;
    private final ObjectMapper objectMapper;

    public DashboardService dashboardService() {
        return this.dashboardService;
    }

    public DashboardSecurity dashboardSecurity() {
        return this.dashboardSecurity;
    }

    public ConfigurationRepository configurationRepository() {
        return this.configurationRepository;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @GET
    public List<DashboardView> search(@QueryParam(value="parentId") String parentId, @QueryParam(value="title") String title) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.dashboardService().search(parentId, title, this.dashboardService().search$default$3()).map((Function1 & Serializable)x$1 -> DashboardView$.MODULE$.apply((Dashboard)x$1))).asJava();
    }

    @GET
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public DashboardView getDashboard(@PathParam(value="dashboardId") String dashboardId, @QueryParam(value="refresh") boolean refresh) {
        Dashboard dashboard;
        block0: {
            this.dashboardSecurity().checkView(dashboardId);
            dashboard = this.dashboardService().findDashboardById(dashboardId);
            if (!refresh) break block0;
            this.dashboardService().evictTilesCache(dashboard);
        }
        return DashboardView$.MODULE$.apply(dashboard);
    }

    @PUT
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public DashboardView updateDashboard(@PathParam(value="dashboardId") String dashboardId, DashboardView dashboard) {
        this.dashboardSecurity().checkEdit(dashboardId);
        dashboard.id_$eq(dashboardId);
        Dashboard updatedDashboard = this.dashboardService().updateDashboard(DashboardView$.MODULE$.toDashboard(dashboard, this.configurationRepository(), this.objectMapper()));
        return DashboardView$.MODULE$.apply(updatedDashboard);
    }

    @POST
    public DashboardView createDashboard(DashboardView dashboard) {
        this.dashboardSecurity().checkCreate(dashboard.parentId());
        dashboard.id_$eq(null);
        Dashboard createdDashboard = this.dashboardService().createDashboard(DashboardView$.MODULE$.toDashboard(dashboard, this.configurationRepository(), this.objectMapper()));
        return DashboardView$.MODULE$.apply(createdDashboard);
    }

    @DELETE
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public void deleteDashboard(@PathParam(value="dashboardId") String dashboardId) {
        this.dashboardSecurity().checkEdit(dashboardId);
        this.dashboardService().deleteDashboard(dashboardId);
    }

    @GET
    @Path(value="/templates")
    public List<Descriptor> listTemplates(@QueryParam(value="scope") @DefaultValue(value="RELEASE") TileScope scope) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.dashboardService().getDashboardTemplates(scope)).asJava();
    }

    @Autowired
    public DashboardResource(DashboardService dashboardService, DashboardSecurity dashboardSecurity, ConfigurationRepository configurationRepository, ObjectMapper objectMapper) {
        this.dashboardService = dashboardService;
        this.dashboardSecurity = dashboardSecurity;
        this.configurationRepository = configurationRepository;
        this.objectMapper = objectMapper;
    }
}

