/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.TriggerPersistenceHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\n\u0014\u0001yA\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\tI\f\u0001C!\u0003wCq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t=\u0001\u0001\"\u0011\u0003\u0012\t!2+\u001d7Ue&<w-\u001a:SKB|7/\u001b;pefT!\u0001F\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0017/\u0005AAO]5hO\u0016\u00148O\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u0019B\u0001A\u0010&UA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"A\n\u0015\u000e\u0003\u001dR!\u0001F\f\n\u0005%:#!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ssB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0006g24GG\u001b\u0006\u0002_\u0005AqM]5{u2,G-\u0003\u00022Y\t9Aj\\4hS:<\u0017A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003oM\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011\u0011H\u000e\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cW-A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u0006dS&#7+\u001a:wS\u000e,W#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001;\u0012aB:feZL7-Z\u0005\u0003\u0005~\u00121bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"2A\u0012%J!\t9\u0005!D\u0001\u0014\u0011\u0015\u0011T\u00011\u00015\u0011\u0015YT\u00011\u0001>\u0003\u00111\u0017N\u001c3\u0016\u00051{ECA'\\!\tqu\n\u0004\u0001\u0005\u000bA3!\u0019A)\u0003\u0003Q\u000b\"AU+\u0011\u0005\u0001\u001a\u0016B\u0001+\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AV-\u000e\u0003]S!\u0001W\f\u0002\r\u0011|W.Y5o\u0013\tQvKA\u0004Ue&<w-\u001a:\t\u000bq3\u0001\u0019A/\u0002\u0013Q\u0014\u0018nZ4fe&#\u0007C\u00010f\u001d\ty6\r\u0005\u0002aC5\t\u0011M\u0003\u0002c;\u00051AH]8pizJ!\u0001Z\u0011\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I\u0006B#AB5\u0011\u0005)\u001cX\"A6\u000b\u00051l\u0017AC1o]>$\u0018\r^5p]*\u0011an\\\u0001\u0005G>\u0014XM\u0003\u0002qc\u0006QQ.[2s_6,G/\u001a:\u000b\u0003I\f!![8\n\u0005Q\\'!\u0002+j[\u0016$\u0007F\u0001\u0004w!\t9h0D\u0001y\u0015\tI(0A\u0006ue\u0006t7/Y2uS>t'BA>}\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003{^\t!\u0001\u001a2\n\u0005}D(AC%t%\u0016\fGm\u00148ms\u000611M]3bi\u0016,B!!\u0002\u0002\nQ!\u0011qAA\u0006!\rq\u0015\u0011\u0002\u0003\u0006!\u001e\u0011\r!\u0015\u0005\b\u0003\u001b9\u0001\u0019AA\u0004\u0003\u001d!(/[4hKJD#aB5\u0002\rU\u0004H-\u0019;f+\u0011\t)\"!\u0007\u0015\t\u0005]\u00111\u0004\t\u0004\u001d\u0006eA!\u0002)\t\u0005\u0004\t\u0006bBA\u0007\u0011\u0001\u0007\u0011q\u0003\u0015\u0003\u0011%\fa\u0001Z3mKR,G\u0003BA\u0012\u0003S\u00012\u0001IA\u0013\u0013\r\t9#\t\u0002\u0005+:LG\u000fC\u0003]\u0013\u0001\u0007Q\f\u000b\u0002\nS\u0006qa-\u001b8e\u0005f4u\u000e\u001c3fe&#G\u0003CA\u0019\u0003\u000f\nY%!\u0016\u0011\u000b\u0005M\u00121I+\u000e\u0005\u0005U\"b\u0001-\u00028)!\u0011\u0011HA\u001e\u0003\u0011!\u0017\r^1\u000b\t\u0005u\u0012qH\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011\u0011I\u0001\u0004_J<\u0017\u0002BA#\u0003k\u0011A\u0001U1hK\"1\u0011\u0011\n\u0006A\u0002u\u000b\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u001bR\u0001\u0019AA(\u00035qWm\u001d;fI\u001a{G\u000eZ3sgB\u0019\u0001%!\u0015\n\u0007\u0005M\u0013EA\u0004C_>dW-\u00198\t\u000f\u0005]#\u00021\u0001\u0002Z\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u00024\u0005m\u0013\u0002BA/\u0003k\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u0015%D#A\u0003<\u000219,XNY3s\u001f\u001a$V-\u001c9mCR,GK]5hO\u0016\u00148\u000f\u0006\u0003\u0002h\u00055\u0004c\u0001\u0011\u0002j%\u0019\u00111N\u0011\u0003\u0007%sG\u000f\u0003\u0004\u0002p-\u0001\r!X\u0001\u000bi\u0016l\u0007\u000f\\1uK&#\u0007FA\u0006jQ\tYa/\u0001\tgS:$')\u001f+f[Bd\u0017\r^3JIR1\u0011\u0011GA=\u0003wBa!a\u001c\r\u0001\u0004i\u0006bBA,\u0019\u0001\u0007\u0011\u0011\f\u0015\u0003\u0019%D#\u0001\u0004<\u0002\u0015\u0019Lg\u000e\u001a\"z)f\u0004X\r\u0006\u0004\u00022\u0005\u0015\u00151\u0017\u0005\b\u0003\u000fk\u0001\u0019AAE\u0003-!(/[4hKJ$\u0016\u0010]3\u0011\r\u0005-\u0015QSAN\u001d\u0011\ti)!%\u000f\u0007\u0001\fy)C\u0001#\u0013\r\t\u0019*I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9*!'\u0003\t1K7\u000f\u001e\u0006\u0004\u0003'\u000b\u0003\u0003BAO\u0003_k!!a(\u000b\t\u0005\u0005\u00161U\u0001\be\u00164G.Z2u\u0015\u0011\t)+a*\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002*\u0006-\u0016A\u00029mk\u001eLgNC\u0002\u0002.f\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003c\u000byJ\u0001\u0003UsB,\u0007bBA,\u001b\u0001\u0007\u0011\u0011\f\u0015\u0003\u001b%D#!\u0004<\u0002A\u001d,GOU;o]&tw\r\u0016:jO\u001e,'/\u001a3SK2,\u0017m]3t\u0007>,h\u000e\u001e\u000b\u0005\u0003O\ni\fC\u0004\u0002@:\u0001\r!!1\u0002\u001bQ,W\u000e\u001d7bi\u0016\u001c\u0015.V5e!\u0011\t\u0019-a9\u000f\t\u0005\u0015\u0017q\u001c\b\u0005\u0003\u000f\fYN\u0004\u0003\u0002J\u0006eg\u0002BAf\u0003/tA!!4\u0002V:!\u0011qZAj\u001d\r\u0001\u0017\u0011[\u0005\u00029%\u0011!dG\u0005\u00031eI!\u0001F\f\n\u0005m<\u0013bA\u001c\u0002^*\u00111pJ\u0005\u0005\u0003'\u000b\tOC\u00028\u0003;LA!!:\u0002h\n)1)[+jI*!\u00111SAqQ\tq\u0011\u000e\u000b\u0002\u000fm\u00061\u0012N\\:feR$&/[4hKJ,GMU3mK\u0006\u001cX\r\u0006\u0005\u0002$\u0005E\u0018Q_A}\u0011\u001d\t\u0019p\u0004a\u0001\u0003\u0003\f1\u0002^3na2\fG/Z+jI\"9\u0011q_\bA\u0002\u0005\u0005\u0017A\u0003;sS\u001e<WM]+jI\"9\u00111`\bA\u0002\u0005\u0005\u0017a\u0005;sS\u001e<WM]3e%\u0016dW-Y:f+&$\u0007FA\bj\u0003Y\u0011X-\\8wKR\u0013\u0018nZ4fe\u0016$'+\u001a7fCN,G\u0003BA\u0012\u0005\u0007AqA!\u0002\u0011\u0001\u0004\u00119!A\u0005d_:$\u0017\u000e^5p]B\u0019aE!\u0003\n\u0007\t-qEA\u0010SK6|g/\u001a+sS\u001e<WM]3e%\u0016dW-Y:f\u0007>tG-\u001b;j_:D#\u0001E5\u0002+\u001d,G\u000fV3oC:$\u0018\n\u001a$peR\u0013\u0018nZ4feR\u0019QLa\u0005\t\u000bq\u000b\u0002\u0019A/)\u0005EI\u0007FA\twQ\r\u0001!1\u0004\t\u0004o\nu\u0011b\u0001B\u0010q\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlTriggerRepository
implements TriggerRepository,
Logging {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTriggerRepository sqlTriggerRepository = this;
        synchronized (sqlTriggerRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = Ids.isInRelease((String)triggerId) ? this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId)))) : this.triggerPersistence().findById(Ids.getName((String)triggerId));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException("Trigger Id [" + trigger.getId() + "] is not valid");
        }
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)triggerType.map((Function1 & Serializable)x$1 -> x$1.toString())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int getRunningTriggeredReleasesCount(Integer templateCiUid) {
        int total = this.triggerPersistence().getRunningTriggeredReleasesCount(templateCiUid);
        this.logger().debug((Function0 & Serializable)() -> "getRunningTriggeredReleasesCount: templateCiUid=" + templateCiUid + ", total=" + total);
        return total;
    }

    @Timed
    public void insertTriggeredRelease(Integer templateUid, Integer triggerUid, Integer triggeredReleaseUid) {
        this.logger().debug((Function0 & Serializable)() -> "insertTriggeredRelease: templateUid=" + templateUid + ", triggerUid=" + triggerUid + ", triggeredReleaseUid=" + triggeredReleaseUid);
        TriggeredReleaseRow row = new TriggeredReleaseRow(templateUid, triggerUid, triggeredReleaseUid);
        this.triggerPersistence().insertTriggeredReleaseRow(row);
    }

    @Timed
    public void removeTriggeredRelease(RemoveTriggeredReleaseCondition condition) {
        this.logger().debug((Function0 & Serializable)() -> "removeTriggeredRelease: " + condition);
        this.triggerPersistence().removeTriggeredReleasesRow(condition);
    }

    @Timed
    @IsReadOnly
    public String getTenantIdForTrigger(String triggerId) {
        return this.triggerPersistence().getTenantIdForTrigger(Ids.getName((String)triggerId));
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
    }
}

