/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002\u00180\u0001iB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00053\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003c\u0011!1\u0007A!b\u0001\n\u00039\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00111\u0004!Q1A\u0005\u00025D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\te\u0002\u0011)\u0019!C\u0001g\"Aq\u000f\u0001B\u0001B\u0003%A\u000f\u0003\u0005y\u0001\t\u0015\r\u0011\"\u0001z\u0011%\t\t\u0001\u0001B\u0001B\u0003%!\u0010\u0003\u0006\u0002\u0004\u0001\u0011)\u0019!C\u0001\u0003\u000bA!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\ty\u0001\u0001BC\u0002\u0013\r\u0011\u0011\u0003\u0005\u000b\u0003\u0003\u0002!\u0011!Q\u0001\n\u0005M\u0001bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\tI\u0006\u0001C!\u0003SCq!a3\u0001\t\u0003\ni\rC\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u001f\u0001\u0011\u0005#q\b\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!\u0011\u0010\u0001\u0005B\tm\u0004b\u0002BA\u0001\u0011\u0005#1\u0011\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0011\u001d\u0011\t\n\u0001C!\u0005'CqA!'\u0001\t\u0003\u0012Y\nC\u0004\u00036\u0002!\tEa.\t\u000f\t-\u0007\u0001\"\u0011\u0003N\"9!\u0011\u001b\u0001\u0005B\tM\u0007b\u0002Bn\u0001\u0011\u0005#Q\u001c\u0005\b\u0005K\u0004A\u0011\tBt\u0011\u001d\u0011Y\u0010\u0001C!\u0005{Dqa!\u0006\u0001\t\u0003\u0012i\u0010C\u0004\u0004\u001c\u0001!\te!\b\t\u000f\rE\u0002\u0001\"\u0011\u00044!911\t\u0001\u0005B\r\u0015\u0003bBB;\u0001\u0011\u00053q\u000f\u0002\u0012'FdG+Y:l%\u0016\u0004xn]5u_JL(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\n!B]3q_NLGo\u001c:z\u0015\t!T'A\u0005yYJ,G.Z1tK*\u0011agN\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001O\u0001\u0004G>l7\u0001A\n\b\u0001m\nU)\u0013'P!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!iQ\u0007\u0002c%\u0011A)\r\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z!\t1u)D\u00010\u0013\tAuFA\rCCN,'+\u001a7fCN,\u0017\n^3n%\u0016\u0004xn]5u_JL\bC\u0001$K\u0013\tYuF\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\t1U*\u0003\u0002O_\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bQa\u001d7gi)T\u0011\u0001V\u0001\tOJL'P\u001f7fI&\u0011a+\u0015\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001X\u0018\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003=n\u0013!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00012\u0011\u0005i\u001b\u0017B\u00013\\\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fa\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\t\u0001\u000e\u0005\u0002[S&\u0011!n\u0017\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012G>lW.\u001a8u%\u0016\u0004xn]5u_JLX#\u00018\u0011\u0005\t{\u0017B\u000192\u0005E\u0019u.\\7f]R\u0014V\r]8tSR|'/_\u0001\u0013G>lW.\u001a8u%\u0016\u0004xn]5u_JL\b%A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012\u0001\u001e\t\u0003\rVL!A^\u0018\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-F\u0001{!\tYh0D\u0001}\u0015\ti8,A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003\u007fr\u0014\u0011eQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\f\u0011dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2fA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s+\t\t9\u0001E\u0002C\u0003\u0013I1!a\u00032\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u00111\u0003\t\u0005\u0003+\tYD\u0004\u0003\u0002\u0018\u0005Ub\u0002BA\r\u0003cqA!a\u0007\u0002.9!\u0011QDA\u0016\u001d\u0011\ty\"!\u000b\u000f\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n:\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u00027o%\u0011A'N\u0005\u0004\u0003_\u0019\u0014A\u00013c\u0013\r\u0001\u00141\u0007\u0006\u0004\u0003_\u0019\u0014\u0002BA\u001c\u0003s\t!bU9m\u0005VLG\u000eZ3s\u0015\r\u0001\u00141G\u0005\u0005\u0003{\tyDA\u0004ES\u0006dWm\u0019;\u000b\t\u0005]\u0012\u0011H\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"\"#a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\u0002XA\u0011a\t\u0001\u0005\u0006/F\u0001\r!\u0017\u0005\u0006AF\u0001\rA\u0019\u0005\u0006MF\u0001\r\u0001\u001b\u0005\u0006YF\u0001\rA\u001c\u0005\u0006eF\u0001\r\u0001\u001e\u0005\u0006qF\u0001\rA\u001f\u0005\b\u0003\u0007\t\u0002\u0019AA\u0004\u0011\u001d\ty!\u0005a\u0002\u0003'\t\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0003;\n\u0019\u0007\u0006\u0003\u0002`\u0005m\u0004\u0003BA1\u0003Gb\u0001\u0001B\u0004\u0002fI\u0011\r!a\u001a\u0003\u0003Q\u000bB!!\u001b\u0002pA\u0019A(a\u001b\n\u0007\u00055THA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001e4\u0003\u0019!w.\\1j]&!\u0011\u0011PA:\u0005\u0011!\u0016m]6\t\u000f\u0005u$\u00031\u0001\u0002\u0000\u00051A/Y:l\u0013\u0012\u0004B!!!\u0002\n:!\u00111QAC!\r\t\t#P\u0005\u0004\u0003\u000fk\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00065%AB*ue&twMC\u0002\u0002\bvB3AEAI!\u0011\t\u0019*!*\u000e\u0005\u0005U%\u0002BAL\u00033\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\tY*!(\u0002\t\r|'/\u001a\u0006\u0005\u0003?\u000b\t+\u0001\u0006nS\u000e\u0014x.\\3uKJT!!a)\u0002\u0005%|\u0017\u0002BAT\u0003+\u0013Q\u0001V5nK\u0012,B!a+\u00020R1\u0011QVAY\u0003g\u0003B!!\u0019\u00020\u00129\u0011QM\nC\u0002\u0005\u001d\u0004bBA?'\u0001\u0007\u0011q\u0010\u0005\b\u0003k\u001b\u0002\u0019AA\\\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!/\u0002F6\u0011\u00111\u0018\u0006\u0004e\u0005u&\u0002BA`\u0003\u0003\fAA[:p]*\u0019\u00111Y\u001a\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\t9-a/\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001a1#!%\u0002%\u0019Lg\u000e\u001a+bg.\u001c()Y:jG\u0012\u000bG/\u0019\u000b\u0005\u0003\u001f\fY\u000f\u0005\u0004\u0002R\u0006m\u0017q\\\u0007\u0003\u0003'TA!!6\u0002X\u0006!Q\u000f^5m\u0015\t\tI.\u0001\u0003kCZ\f\u0017\u0002BAo\u0003'\u0014A\u0001T5tiB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002fF\nQ!];fefLA!!;\u0002d\niA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!!<\u0015\u0001\u0004\ty/A\u0004uCN\\\u0017\nZ:\u0011\r\u0005E\u00171\\A@Q\r!\u0012\u0011\u0013\u0015\u0004)\u0005U\b\u0003BA|\u0003{l!!!?\u000b\t\u0005m\u0018\u0011H\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002\u0000\u0006e(AC%t%\u0016\fGm\u00148ms\u00061Q\r_5tiN$BA!\u0002\u0003\fA\u0019AHa\u0002\n\u0007\t%QHA\u0004C_>dW-\u00198\t\u000f\u0005uT\u00031\u0001\u0002\u0000!\u001aQ#!%)\u0007U\t)0\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003_\u0012)\u0002C\u0004\u0003\u0018Y\u0001\r!a\u001c\u0002\tQ\f7o\u001b\u0015\u0004-\u0005E\u0015aC;qI\u0006$X\rV1tWN$BAa\b\u0003&A\u0019AH!\t\n\u0007\t\rRH\u0001\u0003V]&$\bb\u0002B\u0014/\u0001\u0007!\u0011F\u0001\u0006i\u0006\u001c8n\u001d\t\u0006y\t-\u0012qN\u0005\u0004\u0005[i$A\u0003\u001fsKB,\u0017\r^3e}!\u001aq#!%)\u0007]\u0011\u0019\u0004\u0005\u0003\u00036\teRB\u0001B\u001c\u0015\r\t9*P\u0005\u0005\u0005w\u00119DA\u0004wCJ\f'oZ:\u0002)U\u0004H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t)\u0011\u0011yB!\u0011\t\u000f\t]\u0001\u00041\u0001\u0002p!\u001a\u0001$!%\u00029U\u0004H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t\u0013:$XM\u001d8bYR!!q\u0004B%\u0011\u001d\u00119\"\u0007a\u0001\u0003_\n\u0011DY1uG\",\u0006\u000fZ1uKR\u000b7o\u001b)s_B,'\u000f^5fgR!!q\u0004B(\u0011\u001d\u00119C\u0007a\u0001\u0005#\u0002b!!!\u0003T\u0005=\u0014\u0002\u0002B+\u0003\u001b\u00131aU3uQ\rQ\u0012\u0011S\u0001'E\u0006$8\r[+qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7oV5uQ&#\u0017I\u001c3ICNDG\u0003\u0002B\u0010\u0005;BqAa\n\u001c\u0001\u0004\u0011\t\u0006K\u0002\u001c\u0003#\u000bqCY1uG\",\u0006\u000fZ1uK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\t}!Q\r\u0005\b\u0005Oa\u0002\u0019\u0001B)\u0003y)\b\u000fZ1uKR\u000b7o[!oIJ+G.Z1tK\u001ac\u0017mZ*uCR,8\u000f\u0006\u0004\u0002p\t-$Q\u000e\u0005\b\u0005/i\u0002\u0019AA8\u0011\u001d\u0011y'\ba\u0001\u0005c\nqA]3mK\u0006\u001cX\r\u0005\u0003\u0002r\tM\u0014\u0002\u0002B;\u0003g\u0012qAU3mK\u0006\u001cX\rK\u0002\u001e\u0003#\u000b!\"\u001e9eCR,G+\u001f9f)\u0011\tyG! \t\u000f\t]a\u00041\u0001\u0002p!\u001aa$!%\u0002\r\u0011,G.\u001a;f)\u0011\u0011yB!\"\t\u000f\t]q\u00041\u0001\u0002p!\u001aq$!%\u0002\u0015\r\u0014X-\u0019;f)\u0006\u001c8\u000e\u0006\u0003\u0002p\t5\u0005b\u0002BHA\u0001\u0007\u0011qN\u0001\b]\u0016<H+Y:l\u0003\u0019\u0019'/Z1uKR!\u0011q\u000eBK\u0011\u001d\u0011y)\ta\u0001\u0003_B3!IAI\u0003!iwN^3UCN\\GCCA8\u0005;\u0013\tK!*\u00030\"9!q\u0014\u0012A\u0002\u0005=\u0014A\u0003;bg.$v.T8wK\"9!1\u0015\u0012A\u0002\u0005=\u0014!C7pm\u0016$G+Y:l\u0011\u001d\u00119K\ta\u0001\u0005S\u000ba#\u001e9eCR,Gm\u0014:jO&t7i\u001c8uC&tWM\u001d\t\u0005\u0003c\u0012Y+\u0003\u0003\u0003.\u0006M$!\u0004+bg.\u001cuN\u001c;bS:,'\u000fC\u0004\u00032\n\u0002\rA!+\u0002-U\u0004H-\u0019;fIR\u000b'oZ3u\u0007>tG/Y5oKJD3AIAI\u0003Y1\u0017N\u001c3BM\u001a,7\r^3e\u0005f\u0014E.Y2l_V$H\u0003BAx\u0005sCqAa/$\u0001\u0004\u0011i,\u0001\u0005cY\u0006\u001c7n\\;u!\u0011\u0011yL!2\u000e\u0005\t\u0005'\u0002\u0002Bb\u0003g\n\u0001bY1mK:$\u0017M]\u0005\u0005\u0005\u000f\u0014\tM\u0001\u0005CY\u0006\u001c7n\\;uQ\r\u0019\u0013\u0011S\u0001\u001bM&tG\rU3oI&tw\rV1tWN<\u0016\u000e\u001e5GC\u000e,Go\u001d\u000b\u0003\u0003_D3\u0001JAI\u0003!9W\r\u001e+ji2,G\u0003BA@\u0005+Dq!! &\u0001\u0004\ty\bK\u0002&\u0003#C3!JA{\u0003\u001d9W\r\u001e+za\u0016$B!a \u0003`\"9\u0011Q\u0010\u0014A\u0002\u0005}\u0004f\u0001\u0014\u0002\u0012\"\u001aa%!>\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0003j\n5\bCBAi\u0005W\fy(\u0003\u0003\u0003V\u0005M\u0007b\u0002BxO\u0001\u0007!\u0011_\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u0002=\u0005gL1A!>>\u0005\rIe\u000e\u001e\u0015\u0004O\u0005E\u0005fA\u0014\u0002v\u0006\u0011b-\u001b8e\u001fZ,'\u000fZ;f)\u0006\u001c8.\u00133t)\t\u0011y\u0010\u0005\u0004\u0004\u0002\r-\u0011q\u0010\b\u0005\u0007\u0007\u00199A\u0004\u0003\u0002\"\r\u0015\u0011\"\u0001 \n\u0007\r%Q(A\u0004qC\u000e\\\u0017mZ3\n\t\r51q\u0002\u0002\u0004'\u0016\f(bAB\u0005{!\u001a\u0001&!%)\u0007!\n)0\u0001\ngS:$G)^3T_>tG+Y:l\u0013\u0012\u001c\bfA\u0015\u0002\u0012\"\u001a\u0011&!>\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003BB\u0010\u0007W\u0001Ba!\t\u0004(5\u001111\u0005\u0006\u0005\u0007K\t\u0019(\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0007S\u0019\u0019C\u0001\u0006UCN\\7\u000b^1ukNDq!! +\u0001\u0004\ty\bK\u0002+\u0003#C3AKA{\u0003=9W\r\u001e+bg.\u001cF/\u0019;vg\u0016\u001cH\u0003BB\u001b\u0007w\u0001\u0002\"!5\u00048\u0005}4qD\u0005\u0005\u0007s\t\u0019NA\u0002NCBDqa!\u0010,\u0001\u0004\ty(A\u0005sK2,\u0017m]3JI\"\u001a1&!%)\u0007-\n)0A\u0014gS:$G+Y:l\u0013\u0012\u001c()\u001f+bg.$\u0016\u0010]3Ti\u0006$Xo]!oIN#\u0018M\u001d;ECR,G\u0003\u0003B\u0000\u0007\u000f\u001a\u0019ga\u001a\t\u000f\r%C\u00061\u0001\u0004L\u0005AA/Y:l)f\u0004X\r\u0005\u0003\u0004N\r}SBAB(\u0015\u0011\u0019\tfa\u0015\u0002\u000fI,g\r\\3di*!1QKB,\u0003\r\t\u0007/\u001b\u0006\u0005\u00073\u001aY&\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0007;*\u0014\u0001\u00033fa2|\u00170\u001b;\n\t\r\u00054q\n\u0002\u0005)f\u0004X\rC\u0004\u0004f1\u0002\raa\b\u0002\u0015Q\f7o[*uCR,8\u000fC\u0004\u0004j1\u0002\raa\u001b\u0002\u001bM$\u0018M\u001d;fI\n+gm\u001c:f!\u0011\t\tn!\u001c\n\t\r=\u00141\u001b\u0002\u0005\t\u0006$X\rK\u0002-\u0003#C3\u0001LA{\u0003Q)\b\u000fZ1uKR\u000b7o[*uCR,8\u000fT5oKR1!qDB=\u0007wBq!! .\u0001\u0004\ty\bC\u0004\u0004~5\u0002\r!a \u0002\u0015M$\u0018\r^;t\u0019&tW\rK\u0002\u0001\u0007\u0003\u0003B!a>\u0004\u0004&!1QQA}\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Long gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) throws NotFoundException {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Task> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Task>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException("Repository entity [" + taskId + "] not found", new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + taskId + "] not found in release", new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskRow data = (TaskRow)some.value();
                    return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
                }
            }
            return None$.MODULE$;
        })).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking if exists task [" + taskId + "]");
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.interceptUpdate((ConfigurationItem)task);
        this.releasePersistence().update(release);
        this.updateTaskPropertiesInternal(task);
        this.updateConfigurationRefs((CiWithUid)release);
        this.afterUpdate((ConfigurationItem)task);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.interceptUpdate((ConfigurationItem)task);
        this.updateTaskPropertiesInternal(task);
        this.afterUpdate((ConfigurationItem)task);
    }

    private void updateTaskPropertiesInternal(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskPropertiesInternal$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        this.batchUpdateDependencies(tasks);
    }

    @Timed
    public void batchUpdateTaskPropertiesWithIdAndHash(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskPropertiesWithIdAndHash(tasks);
        this.batchUpdateDependencies(tasks);
    }

    private void batchUpdateDependencies(scala.collection.immutable.Set<Task> tasks) {
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple22._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
        tasks.foreach((Function1 & Serializable)ci -> {
            this.afterUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    @Timed
    public Task updateType(Task task) {
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return updated;
    }

    @Timed
    public void delete(Task task) {
        String taskId = task.getId();
        this.checkIsNotReferencedByDependencies(taskId);
        this.interceptDelete(taskId);
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
        this.afterDelete(taskId);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    @Timed
    public Task create(Task newTask) {
        this.interceptCreate((ConfigurationItem)newTask);
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        this.afterCreate((ConfigurationItem)createdTask);
        return createdTask;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        this.interceptUpdate((ConfigurationItem)movedTask);
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$)).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public String getType(String taskId) {
        return (String)this.taskPersistence().getType(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("getStatus: could not find task '" + taskId + "'", new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Release release = (Release)tuple2._1();
            scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.interceptUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.releasePersistence().update(release);
            tasks.foreach((Function1 & Serializable)task -> {
                $this.updateTaskPropertiesInternal(task);
                return BoxedUnit.UNIT;
            });
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.afterUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.updateConfigurationRefs((CiWithUid)release);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateTaskPropertiesInternal$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        BoxedUnit boxedUnit;
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            return;
        }
        try {
            $this.dependencyPersistence().updateDependency(dependency);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (NotFoundException e) {
            $this.logger().error((Function0 & Serializable)() -> "Dependency " + dependency + " not found when updating task " + task$1, (Function0 & Serializable)() -> e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

