/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication;

import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.kerberos.authentication.JaasSubjectHolder;
import org.springframework.security.kerberos.authentication.KerberosAuthentication;

public class KerberosMultiTier {
    public static final String KERBEROS_OID_STRING = "1.2.840.113554.1.2.2";
    public static final Oid KERBEROS_OID = KerberosMultiTier.createOid("1.2.840.113554.1.2.2");

    public static Authentication authenticateService(Authentication authentication, final String username, final int lifetimeInSeconds, final String targetService) {
        KerberosAuthentication kerberosAuthentication = (KerberosAuthentication)authentication;
        final JaasSubjectHolder jaasSubjectHolder = kerberosAuthentication.getJaasSubjectHolder();
        Subject subject = jaasSubjectHolder.getJaasSubject();
        Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                KerberosMultiTier.runAuthentication(jaasSubjectHolder, username, lifetimeInSeconds, targetService);
                return null;
            }
        });
        return authentication;
    }

    public static byte[] getTokenForService(Authentication authentication, String principalName) {
        KerberosAuthentication kerberosAuthentication = (KerberosAuthentication)authentication;
        JaasSubjectHolder jaasSubjectHolder = kerberosAuthentication.getJaasSubjectHolder();
        return jaasSubjectHolder.getToken(principalName);
    }

    private static void runAuthentication(JaasSubjectHolder jaasContext, String username, int lifetimeInSeconds, String targetService) {
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSName clientName = manager.createName(username, GSSName.NT_USER_NAME);
            GSSCredential clientCredential = manager.createCredential(clientName, lifetimeInSeconds, KERBEROS_OID, 1);
            GSSName serverName = manager.createName(targetService, GSSName.NT_USER_NAME);
            GSSContext securityContext = manager.createContext(serverName, KERBEROS_OID, clientCredential, 0);
            securityContext.requestCredDeleg(true);
            securityContext.requestInteg(false);
            securityContext.requestAnonymity(false);
            securityContext.requestMutualAuth(false);
            securityContext.requestReplayDet(false);
            securityContext.requestSequenceDet(false);
            boolean established = false;
            byte[] outToken = new byte[]{};
            while (!established) {
                byte[] inToken = new byte[]{};
                outToken = securityContext.initSecContext(inToken, 0, inToken.length);
                established = securityContext.isEstablished();
            }
            jaasContext.addToken(targetService, outToken);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Kerberos authentication failed", (Throwable)e);
        }
    }

    private static Oid createOid(String oid) {
        try {
            return new Oid(oid);
        }
        catch (GSSException e) {
            throw new IllegalStateException("Unable to instantiate Oid: ", e);
        }
    }
}

