/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.serialization.kryo.scala;

import io.altoo.serialization.kryo.scala.Transformer;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I4A!\u0004\b\u00013!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004b\u0002!\u0001\u0005\u0004%i!\u0011\u0005\u0007\t\u0002\u0001\u000bQ\u0002\"\t\r\u0015\u0003\u0001\u0015!\u0003G\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0006\"\u0002.\u0001\t\u0003Z\u0006\"\u0002.\u0001\t\u0003r\u0006\"\u00027\u0001\t\u0003j\u0007\"\u00027\u0001\t\u0003\u0002(!E&ss>\u001c%/\u001f9u_\u001e\u0014\u0018\r\u001d5fe*\u0011q\u0002E\u0001\u0006g\u000e\fG.\u0019\u0006\u0003#I\tAa\u001b:z_*\u00111\u0003F\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005U1\u0012!B1mi>|'\"A\f\u0002\u0005%|7\u0001A\n\u0004\u0001iy\u0002CA\u000e\u001e\u001b\u0005a\"\"A\b\n\u0005ya\"AB!osJ+g\r\u0005\u0002!C5\ta\"\u0003\u0002#\u001d\tYAK]1og\u001a|'/\\3s\u0003\rYW-\u001f\t\u00047\u0015:\u0013B\u0001\u0014\u001d\u0005\u0015\t%O]1z!\tY\u0002&\u0003\u0002*9\t!!)\u001f;f\u0003\u0011iw\u000eZ3\u0011\u00051\u001adBA\u00172!\tqC$D\u00010\u0015\t\u0001\u0004$\u0001\u0004=e>|GOP\u0005\u0003eq\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!\u0007H\u0001\tSZdUM\\4uQB\u00111\u0004O\u0005\u0003sq\u00111!\u00138u\u0003\u0019a\u0014N\\5u}Q!A(\u0010 @!\t\u0001\u0003\u0001C\u0003$\t\u0001\u0007A\u0005C\u0003+\t\u0001\u00071\u0006C\u00037\t\u0001\u0007q'A\u0007BkRDG+Y4MK:<G\u000f[\u000b\u0002\u0005>\t1)\b\u0002\u0001\u0001\u0007q\u0011)\u001e;i)\u0006<G*\u001a8hi\"\u0004\u0013aB6fsN\u0003Xm\u0019\t\u0003\u000f:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAa\u001d9fG*\u00111\nT\u0001\u0007GJL\b\u000f^8\u000b\u00035\u000bQA[1wCbL!a\u0014%\u0003\u001bM+7M]3u\u0017\u0016L8\u000b]3d\u0003\u0019\u0011\u0018M\u001c3p[V\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006A1/Z2ve&$\u0018PC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&\u0001D*fGV\u0014XMU1oI>l\u0017\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0005\u0011b\u0006\"B/\n\u0001\u0004!\u0013!\u00039mC&tG/\u001a=u)\ry&\r\u001a\t\u00037\u0001L!!\u0019\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006G*\u0001\r\u0001J\u0001\nS:\u0004X\u000f\u001e\"vM\u001aDQ!\u001a\u0006A\u0002\u0019\f!b\\;uaV$()\u001e4g!\t9'.D\u0001i\u0015\tIg+A\u0002oS>L!a\u001b5\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\u0006ge>l')\u001b8bef$\"\u0001\n8\t\u000b=\\\u0001\u0019\u0001\u0013\u0002\u000b%t\u0007/\u001e;\u0015\u0005\u0011\n\b\"B2\r\u0001\u00041\u0007")
public class KryoCryptographer
implements Transformer {
    private SecureRandom random;
    private final String mode;
    private final int ivLength;
    private final SecretKeySpec keySpec;
    private volatile boolean bitmap$0;

    private final int AuthTagLength() {
        return 128;
    }

    private SecureRandom random$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.random = new SecureRandom();
                this.bitmap$0 = true;
            }
        }
        return this.random;
    }

    private SecureRandom random() {
        if (!this.bitmap$0) {
            return this.random$lzycompute();
        }
        return this.random;
    }

    @Override
    public byte[] toBinary(byte[] plaintext) {
        Cipher cipher = Cipher.getInstance(this.mode);
        byte[] iv = new byte[this.ivLength];
        this.random().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.keySpec, parameterSpec);
        byte[] ciphertext = cipher.doFinal(plaintext);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + ciphertext.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(ciphertext);
        return byteBuffer.array();
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        Cipher cipher = Cipher.getInstance(this.mode);
        byte[] iv = new byte[this.ivLength];
        this.random().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.keySpec, parameterSpec);
        outputBuff.putInt(iv.length);
        outputBuff.put(iv);
        cipher.doFinal(ByteBuffer.wrap(inputBuff), outputBuff);
    }

    @Override
    public byte[] fromBinary(byte[] input) {
        return this.fromBinary(ByteBuffer.wrap(input));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        Cipher cipher = Cipher.getInstance(this.mode);
        int ivLength = inputBuff.getInt();
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        byte[] iv = new byte[ivLength];
        inputBuff.get(iv);
        byte[] ciphertext = new byte[inputBuff.remaining()];
        inputBuff.get(ciphertext);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.keySpec, parameterSpec);
        return cipher.doFinal(ciphertext);
    }

    public KryoCryptographer(byte[] key, String mode, int ivLength) {
        this.mode = mode;
        this.ivLength = ivLength;
        Transformer.$init$(this);
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        this.keySpec = new SecretKeySpec(key, "AES");
    }
}

