import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import './active-tile.skeleton.less';

export const ActiveTileSkeleton = () => (
    <div className="active-tile-skeleton">
        <div>
            <div className="active-tile-skeleton-header">
                <DotSkeleton height="40px" variant="circular" width="40px" />
                <div className="active-tile-skeleton-title">
                    <DotSkeleton className="round-border" height="12px" variant="rectangular" width="100%" />
                    <DotSkeleton className="round-border" height="10px" variant="rectangular" width="50%" />
                </div>
            </div>
            <div className="active-tile-skeleton-content">
                <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100%" />
                <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100%" />
                <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100%" />
            </div>
        </div>
        <div className="active-tile-skeleton-footer">
            <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100px" />
            <div className="active-tile-skeleton-footer-right">
                <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100px" />
                <DotSkeleton className="round-border" height="40px" variant="rectangular" width="100px" />
            </div>
        </div>
    </div>
);
