import React from 'react';
import { InputWithScalar } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';
import { TaskInputCommonProps } from '@xlr-ui/app/features/tasks/components/rails/config/components/types';
import { RemoteScriptTask } from '@xlr-ui/app/types';

/**
 * textarea input with or without variable interpolation
 */
export const RemoteScriptTextarea = (props: TaskInputCommonProps) => {
    const remoteTask = props.task as RemoteScriptTask;
    const ignoreInterpolateVariables = remoteTask.inputProperties.scriptIgnoreVariableInterpolation.value;

    return <InputWithScalar {...props} interpolateVariables={!ignoreInterpolateVariables} type="textarea" />;
};

/**
 * boolean input without variable
 */
export const InputWithBoolean = (props: TaskInputCommonProps) => {
    return <InputWithScalar {...props} type="boolean" />;
};
