import React, { memo } from 'react';
import { DotButton, DotCard, DotIllustration, DotTypography } from '@digital-ai/dot-components';
import './choose-onboard-connect.component.less';

const ChooseOnboardConnectComponent = () => {
    // eslint-disable-next-line max-params
    const renderContentCard = (illustrationId: string, title: string, description: string, buttonText: string) => (
        <DotCard className="content-card" data-testid={illustrationId}>
            <div className="content-card-illustration">
                <DotIllustration illustrationId={illustrationId} />
            </div>
            <DotTypography variant="h2">{title}</DotTypography>
            <DotTypography className="content-card-description" variant="body1">
                {description}
            </DotTypography>
            <div className="content-card-button">
                <DotButton disabled={true} type="primary">
                    {buttonText}
                </DotButton>
            </div>
        </DotCard>
    );

    return (
        <div className="choose-onboard-connect">
            <div className="choose-onboard-connect-content">
                <div className="content-header">
                    <DotTypography variant="h1">Setup live deployments</DotTypography>
                    <DotTypography className="content-header-subtitle" variant="body1">
                        Setup live deployment anywhere in your pipeline
                    </DotTypography>
                </div>

                <div className="content-cards">
                    {renderContentCard(
                        'launch',
                        'Onboard new deployment',
                        'Set up new deployments in external system like Digital.ai Deploy or ArgoCD by using step-by-step workflow',
                        'Onboard',
                    )}
                    {renderContentCard(
                        'disconnected',
                        'Connect existing deployment',
                        'Listen to existing deployments from external systems like Digital.ai Deploy or ArgoCD',
                        'Connect',
                    )}
                </div>
            </div>
        </div>
    );
};

export const ChooseOnboardConnect = memo(ChooseOnboardConnectComponent);
