import React from 'react';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { ExternalDeploymentDeleteApplicationDialog } from './external-deployment-delete-application-dialog.component';
import { DotConfirmationDialog, DotLink } from '@digital-ai/dot-components';

describe('ExternalDeploymentDeleteApplicationDialogComponent', () => {
    let wrapper: ReactWrapper;
    const onCancel = jest.fn();
    const onSubmit = jest.fn();

    const defaultProps = {
        applicationName: 'testApp',
        connectionLabel: 'Deploy',
        deploymentLink: 'localhost:4516',
        isOpen: true,
        onCancel,
        onSubmit,
    };

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<ExternalDeploymentDeleteApplicationDialog {...props} />);
    };

    afterEach(() => jest.resetAllMocks());

    it('should render component with correct elements', () => {
        mount();
        const dialog = wrapper.find(DotConfirmationDialog);
        expect(dialog).toExist();

        const dialogProps = dialog.props();
        expect(dialogProps.title).toBe('Delete Application');
        expect(dialogProps.open).toBe(true);

        const content = wrapper.findWhere((node) => node.is('div') && node.props()['data-test-id'] === 'confirmation-dialog-content');
        expect(content).toExist();
        expect(content).toIncludeText('This will also do changes to original deployment');
        expect(content.find(DotLink).props().href).toBe('localhost:4516');
        expect(content.find(DotLink).text()).toBe('Deploy');
    });
});
