import React from 'react';
import { LabelListHeaderComponent } from './label-list-header-component';
import { mountWithStoreAndTheme, preparePortalContainer, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { DotInputText } from '@digital-ai/dot-components';
import { ActionToolbarPortal } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';

describe('Label list header component', () => {
    let wrapper: ReactWrapper;
    const onCreate = jest.fn();
    const onFilterChange = jest.fn();

    const mount = () => {
        wrapper = mountWithStoreAndTheme(<LabelListHeaderComponent onCreate={onCreate} onFilterChange={onFilterChange} />);
    };
    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should render with model', () => {
        const portal: ReactWrapper = wrapper.find('ActionToolbarPortalContainer');
        expect(portal.prop('helpLink')).toBe('how-to/using-environments');

        expect(wrapper.find(DotInputText)).toExist();
        expect(portal.find(ActionToolbarPortal)).toExist();
    });

    it('should show button', () => {
        const portal = wrapper.find('ActionToolbarPortalContainer');
        const button = portal.find('button');
        expect(button).toExist();
        button.at(0).simulate('click');
        expect(onCreate).toBeCalledTimes(1);
    });

    it('should change filter', () => {
        const input = wrapper.find(DotInputText);
        expect(input).toExist();
        input.invoke('onChange')({ target: { value: 'abc' } });
        expect(onFilterChange).toBeCalledTimes(1);
    });
});
