/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.PhaseClosedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseProgressCalculated;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedFromEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskReopenedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.ProgressRepository;
import com.xebialabs.xlrelease.risk.service.ReleaseProgressWithReleaseId;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)Q\b\u0001C\u0001}!)!\u000b\u0001C\u0001'\")A\r\u0001C\u0001K\")1\u000e\u0001C\u0001Y\")1\u000f\u0001C\u0001i\")1\u0010\u0001C\u0001y\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\t9\f\u0001C\u0005\u0003s\u0013q\u0002\u0015:pOJ,7o]*feZL7-\u001a\u0006\u0003-]\tqa]3sm&\u001cWM\u0003\u0002\u00193\u0005!!/[:l\u0015\tQ2$A\u0005yYJ,G.Z1tK*\u0011A$H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AH\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)1\u000f\u001c45U*\tA&\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0013FA\u0004M_\u001e<\u0017N\\4\u0002%A\u0014xn\u001a:fgN\u0014V\r]8tSR|'/\u001f\t\u0003cQj\u0011A\r\u0006\u0003g]\t!B]3q_NLGo\u001c:z\u0013\t)$G\u0001\nQe><'/Z:t%\u0016\u0004xn]5u_JL\u0018\u0001C3wK:$()^:\u0011\u0005aZT\"A\u001d\u000b\u0005iJ\u0012AB3wK:$8/\u0003\u0002=s\tAQI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0005\u0013\u0005C\u0001!\u0001\u001b\u0005)\u0002\"B\u0018\u0004\u0001\u0004\u0001\u0004\"\u0002\u001c\u0004\u0001\u00049\u0004FA\u0002E!\t)\u0005+D\u0001G\u0015\t9\u0005*\u0001\u0006b]:|G/\u0019;j_:T!!\u0013&\u0002\u000f\u0019\f7\r^8ss*\u00111\nT\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u001b:\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005E3%!C!vi><\u0018N]3e\u00039\u0011X\r\\3bg\u0016\u001c%/Z1uK\u0012$\"\u0001V,\u0011\u0005\t*\u0016B\u0001,$\u0005\u0011)f.\u001b;\t\u000ba#\u0001\u0019A-\u0002'I,G.Z1tK\u000e\u0013X-\u0019;fI\u00163XM\u001c;\u0011\u0005isV\"A.\u000b\u0005ib&BA/\u001a\u0003\u0019!w.\\1j]&\u0011ql\u0017\u0002\u0014%\u0016dW-Y:f\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\t\u0005\u0004\"\u0001\u000f2\n\u0005\rL$!C*vEN\u001c'/\u001b2f\u0003A\u0001\b.Y:f\u00072|7/\u001a3Fm\u0016tG\u000f\u0006\u0002UM\")A-\u0002a\u0001OB\u0011!\f[\u0005\u0003Sn\u0013\u0001\u0003\u00155bg\u0016\u001cEn\\:fI\u00163XM\u001c;)\u0005\u0015\t\u0017a\u00049iCN,G)\u001e9mS\u000e\fG/\u001a3\u0015\u0005Qk\u0007\"\u00028\u0007\u0001\u0004y\u0017\u0001\u00069iCN,G)\u001e9mS\u000e\fG/\u001a3Fm\u0016tG\u000f\u0005\u0002[a&\u0011\u0011o\u0017\u0002\u0015!\"\f7/\u001a#va2L7-\u0019;fI\u00163XM\u001c;)\u0005\u0019\t\u0017\u0001\u00049iCN,G)\u001a7fi\u0016$GC\u0001+v\u0011\u00151x\u00011\u0001x\u0003E\u0001\b.Y:f\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\t\u00035bL!!_.\u0003#AC\u0017m]3EK2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\bC\u0006YA/Y:l'.L\u0007\u000f]3e)\t!V\u0010C\u0003\u007f\u0011\u0001\u0007q0\u0001\tuCN\\7k[5qa\u0016$WI^3oiB\u0019!,!\u0001\n\u0007\u0005\r1L\u0001\tUCN\\7k[5qa\u0016$WI^3oi\"\u0012\u0001\"Y\u0001\u000ei\u0006\u001c8nQ8na2,G/\u001a3\u0015\u0007Q\u000bY\u0001C\u0004\u0002\u000e%\u0001\r!a\u0004\u0002%Q\f7o[\"p[BdW\r^3e\u000bZ,g\u000e\u001e\t\u00045\u0006E\u0011bAA\n7\n\u0011B+Y:l\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8uQ\tI\u0011-A\u0006uCN\\7I]3bi\u0016$Gc\u0001+\u0002\u001c!9\u0011Q\u0004\u0006A\u0002\u0005}\u0011\u0001\u0005;bg.\u001c%/Z1uK\u0012,e/\u001a8u!\rQ\u0016\u0011E\u0005\u0004\u0003GY&\u0001\u0005+bg.\u001c%/Z1uK\u0012,e/\u001a8uQ\tQ\u0011-\u0001\buCN\\G)\u001e9mS\u000e\fG/\u001a3\u0015\u0007Q\u000bY\u0003C\u0004\u0002.-\u0001\r!a\f\u0002\u001fQ\f7o[\"pa&,G-\u0012<f]R\u00042AWA\u0019\u0013\r\t\u0019d\u0017\u0002\u0010)\u0006\u001c8nQ8qS\u0016$WI^3oi\"\u00121\"Y\u0001\u000fi\u0006\u001c8nQ8qS\u0016$gI]8n)\r!\u00161\b\u0005\b\u0003{a\u0001\u0019AA \u0003M!\u0018m]6D_BLW\r\u001a$s_6,e/\u001a8u!\rQ\u0016\u0011I\u0005\u0004\u0003\u0007Z&a\u0005+bg.\u001cu\u000e]5fI\u001a\u0013x.\\#wK:$\bF\u0001\u0007b\u0003-!\u0018m]6EK2,G/\u001a3\u0015\u0007Q\u000bY\u0005C\u0004\u0002N5\u0001\r!a\u0014\u0002!Q\f7o\u001b#fY\u0016$X\rZ#wK:$\bc\u0001.\u0002R%\u0019\u00111K.\u0003!Q\u000b7o\u001b#fY\u0016$X\rZ#wK:$\bFA\u0007b\u00031!\u0018m]6SK>\u0004XM\\3e)\r!\u00161\f\u0005\b\u0003;r\u0001\u0019AA0\u0003E!\u0018m]6SK>\u0004XM\\3e\u000bZ,g\u000e\u001e\t\u00045\u0006\u0005\u0014bAA27\n\tB+Y:l%\u0016|\u0007/\u001a8fI\u00163XM\u001c;)\u00059\t\u0017!F;qI\u0006$XMU3mK\u0006\u001cX\r\u0015:pOJ,7o\u001d\u000b\u0004)\u0006-\u0004bBA7\u001f\u0001\u0007\u0011qN\u0001\be\u0016dW-Y:f!\u0011\t\t(a\u001d\u000e\u0003qK1!!\u001e]\u0005\u001d\u0011V\r\\3bg\u0016D3aDA=!\u0011\tY(a#\u000e\u0005\u0005u$bA$\u0002\u0000)!\u0011\u0011QAB\u0003\u0011\u0019wN]3\u000b\t\u0005\u0015\u0015qQ\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAE\u0003\tIw.\u0003\u0003\u0002\u000e\u0006u$!\u0002+j[\u0016$\u0017!D:u_J,\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002\u0014\u0006\u0005\u0006\u0003BAK\u0003;k!!a&\u000b\t\u0005e\u00151T\u0001\taJ|wM]3tg*\u0011QlF\u0005\u0005\u0003?\u000b9JA\bSK2,\u0017m]3Qe><'/Z:t\u0011\u001d\t\u0019\u000b\u0005a\u0001\u0003K\u000bAD]3mK\u0006\u001cX\r\u0015:pOJ,7o],ji\"\u0014V\r\\3bg\u0016LE\rE\u0002A\u0003OK1!!+\u0016\u0005q\u0011V\r\\3bg\u0016\u0004&o\\4sKN\u001cx+\u001b;i%\u0016dW-Y:f\u0013\u0012\f\u0001dY1mGVd\u0017\r^3SK2,\u0017m]3Qe><'/Z:t)\u0011\t)+a,\t\u000f\u00055\u0014\u00031\u0001\u0002p\u0005\t2-\u00197dk2\fG/\u001a)s_\u001e\u0014Xm]:\u0015\t\u0005M\u0015Q\u0017\u0005\b\u0003[\u0012\u0002\u0019AA8\u0003=I7\u000fV1tW\u000e{W\u000e\u001d7fi\u0016$G\u0003BA^\u0003\u0003\u00042AIA_\u0013\r\tyl\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019m\u0005a\u0001\u0003\u000b\fA\u0001^1tWB!\u0011\u0011OAd\u0013\r\tI\r\u0018\u0002\u0005)\u0006\u001c8\u000eK\u0002\u0001\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'd\u0015AC:uKJ,w\u000e^=qK&!\u0011q[Ai\u0005\u001d\u0019VM\u001d<jG\u0016D3\u0001AAn!\rA\u0014Q\\\u0005\u0004\u0003?L$!D#wK:$H*[:uK:,'\u000f")
public class ProgressService
implements Logging {
    private final ProgressRepository progressRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ProgressService progressService = this;
        synchronized (progressService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseClosedEvent(PhaseClosedEvent phaseClosedEvent) {
        this.updateReleaseProgress(phaseClosedEvent.phase().getRelease());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCopiedFrom(TaskCopiedFromEvent taskCopiedFromEvent) {
        this.updateReleaseProgress(taskCopiedFromEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.updateReleaseProgress(taskDeletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskReopened(TaskReopenedEvent taskReopenedEvent) {
        this.updateReleaseProgress(taskReopenedEvent.task().getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            ReleaseProgressWithReleaseId releaseProgressWithId = this.calculateReleaseProgress(release);
            this.storeProgress(releaseProgressWithId);
            return;
        }
    }

    private ReleaseProgress storeProgress(ReleaseProgressWithReleaseId releaseProgressWithReleaseId) {
        ReleaseProgress savedReleaseProgress = this.progressRepository.createOrUpdate(releaseProgressWithReleaseId.releaseProgress());
        this.eventBus.publish((XLReleaseEvent)new ReleaseProgressCalculated(releaseProgressWithReleaseId.releaseId(), (ReleaseExtension)savedReleaseProgress));
        return savedReleaseProgress;
    }

    private ReleaseProgressWithReleaseId calculateReleaseProgress(Release release) {
        return new ReleaseProgressWithReleaseId(release.getId(), this.calculateProgress(release));
    }

    private ReleaseProgress calculateProgress(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Calculating progress of release " + release.getId());
        List allTasks = release.getAllTasks();
        int totalTasks = allTasks.size();
        int tasksCompleted = CollectionConverters$.MODULE$.ListHasAsScala(allTasks).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
        ReleaseProgress releaseProgress = new ReleaseProgress();
        releaseProgress.setId(release.getId() + "/progress");
        releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
        releaseProgress.setTotalTasks(totalTasks);
        scala.collection.immutable.Map phasesProgress = (scala.collection.immutable.Map)CollectionConverters$.MODULE$.ListHasAsScala(release.getPhases()).asScala().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
                Phase phase = (Phase)tuple2._2();
                int totalPhaseTasks = phase.getAllTasks().size();
                int tasksCompletedInPhase = CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
                return (scala.collection.immutable.Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase.getId()), (Object)(totalPhaseTasks + ";" + tasksCompletedInPhase)));
            }
            throw new MatchError((Object)tuple2);
        });
        releaseProgress.setPhasesProgress(CollectionConverters$.MODULE$.MapHasAsJava((Map)phasesProgress).asJava());
        return releaseProgress;
    }

    private boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }

    @Autowired
    public ProgressService(ProgressRepository progressRepository, EventBus eventBus) {
        this.progressRepository = progressRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

