/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class BufferedRandomAccessFile {
    private final RandomAccessFile randomAccessFile;
    private final byte[] buffer;
    private int bufferSize;
    private long bufferPointer;
    private long filePointer;

    public BufferedRandomAccessFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 32768);
    }

    public BufferedRandomAccessFile(RandomAccessFile randomAccessFile, int bufferCapacity) {
        this.randomAccessFile = randomAccessFile;
        this.buffer = new byte[bufferCapacity];
        this.bufferSize = 0;
        this.bufferPointer = 0L;
        this.filePointer = 0L;
    }

    public void loadPosition() throws IOException {
        this.filePointer = this.randomAccessFile.getFilePointer();
    }

    public void savePosition() throws IOException {
        this.randomAccessFile.seek(this.filePointer);
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    public FileChannel getChannel() {
        return this.randomAccessFile.getChannel();
    }

    public int read() throws IOException {
        long filePointer = this.getFilePointer();
        if (filePointer >= this.bufferPointer && filePointer < this.bufferPointer + (long)this.bufferSize) {
            int bufferOffset = (int)(filePointer - this.bufferPointer);
            this.seek(filePointer + 1L);
            return this.buffer[bufferOffset] & 0xFF;
        }
        this.bufferSize = 0;
        this.bufferPointer = filePointer;
        this.randomAccessFile.seek(this.getFilePointer());
        int bytesRead = this.randomAccessFile.read(this.buffer);
        if (bytesRead < 0) {
            return -1;
        }
        this.seek(filePointer + 1L);
        this.bufferSize = bytesRead;
        return this.buffer[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long right;
        long filePointer = this.getFilePointer();
        long left = Math.max(filePointer, this.bufferPointer);
        if (left < (right = Math.min(filePointer + left, this.bufferPointer + (long)this.bufferSize))) {
            int bytesRead;
            if (filePointer < left) {
                this.randomAccessFile.seek(this.getFilePointer());
                bytesRead = this.randomAccessFile.read(b, off, (int)(left - filePointer));
                if (bytesRead < 0) {
                    return bytesRead;
                }
            }
            System.arraycopy(this.buffer, (int)(left - this.bufferPointer), b, off + (int)(left - filePointer), (int)(right - left));
            if (filePointer + (long)len > right) {
                this.randomAccessFile.seek(right);
                bytesRead = this.randomAccessFile.read(this.buffer, 0, this.buffer.length);
                if (bytesRead < 0) {
                    this.bufferSize = 0;
                    this.seek(right);
                    return (int)(right - filePointer);
                }
                this.bufferSize = bytesRead;
                int bytesToCopy = (int)Math.min((long)bytesRead, filePointer + (long)len - right);
                System.arraycopy(this.buffer, 0, b, off + (int)(right - filePointer), bytesToCopy);
                this.seek(right + (long)bytesToCopy);
                return (int)(right - filePointer + (long)bytesToCopy);
            }
            this.seek(right);
            return (int)(right - filePointer);
        }
        this.randomAccessFile.seek(this.getFilePointer());
        int bytesRead = this.randomAccessFile.read(b, off, len);
        if (bytesRead >= 0) {
            this.seek(this.getFilePointer() + (long)bytesRead);
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        this.filePointer = pos;
    }
}

