/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.views.BaseView;
import com.xebialabs.xlrelease.views.ReleaseExtensionView;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionsViewConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

abstract class BaseReleaseConverter {
    BaseReleaseConverter() {
    }

    protected abstract ReleaseExtensionsViewConverter getReleaseExtensionsViewConverter();

    protected void populateSyntheticProperties(Release release, BaseView view, List<String> properties) {
        HashMap<String, Object> syntheticProperties = new HashMap<String, Object>();
        release.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> properties.contains(pd.getName())).forEach(pd -> {
            if (pd.getKind() == PropertyKind.CI) {
                ConfigurationItem ci = (ConfigurationItem)pd.get((ConfigurationItem)release);
                syntheticProperties.put(pd.getName(), null != ci ? ci.getId() : null);
            } else {
                syntheticProperties.put(pd.getName(), pd.get((ConfigurationItem)release));
            }
        });
        view.setSyntheticProperties(syntheticProperties);
    }

    protected void populateExtensions(Release release, BaseView view, List<String> extensions) {
        List releaseExtensions = release.getExtensions();
        HashMap<String, ReleaseExtensionView> extensionMap = new HashMap<String, ReleaseExtensionView>();
        extensions.forEach(extension -> {
            Optional<ReleaseExtension> e = releaseExtensions.stream().filter(releaseExtension -> Ids.getName((String)releaseExtension.getId()).equals(extension)).findFirst();
            e.ifPresent(releaseExtension -> extensionMap.put((String)extension, this.getReleaseExtensionsViewConverter().toView((ReleaseExtension)releaseExtension)));
        });
        view.setExtensions(extensionMap);
    }
}

