/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.reports.domain.ReportCellError;
import com.xebialabs.xlrelease.reports.domain.ReportSheetError;
import com.xebialabs.xlrelease.reports.excel.ErrorSheet;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.ExcelStyles;
import com.xebialabs.xlrelease.reports.excel.Export;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportWorkbook {
    private static final String WARNING_EMOJI_UNICODE = "\u26a0";
    private XSSFWorkbook workbook;
    private ExcelStyles styles;
    private List<ReportCellError> cellErrors = new ArrayList<ReportCellError>();
    private List<ReportSheetError> sheetErrors = new ArrayList<ReportSheetError>();
    private AtomicBoolean errorSheetAdded = new AtomicBoolean(false);

    public ReportWorkbook() {
        this.workbook = new XSSFWorkbook();
        this.styles = new ExcelStyles(this.workbook);
    }

    public XSSFWorkbook getWorkbookWithoutErrorSheet() {
        Export.preventDynamicDataExchangeAttack(this.workbook);
        return this.workbook;
    }

    public ExcelSheetWriter createReportSection(String title) {
        return new ExcelSheetWriter(this, this.workbook.createSheet(title), this.styles);
    }

    public XSSFWorkbook makeWorkbookWithErrors(ExcelStyles styles) {
        this.addErrorSheetIfNecessary(styles);
        Export.preventDynamicDataExchangeAttack(this.workbook);
        return this.workbook;
    }

    private void addErrorSheetIfNecessary(ExcelStyles styles) {
        if (this.errorSheetAdded.getAndSet(true)) {
            throw new IllegalStateException("Error sheet added more than once");
        }
        if (!this.cellErrors.isEmpty() || !this.sheetErrors.isEmpty()) {
            ExcelSheetWriter reportSection = this.createReportSection(String.format("%s Report errors (%d)", WARNING_EMOJI_UNICODE, this.cellErrors.size() + this.sheetErrors.size()));
            new ErrorSheet(reportSection).addContent(styles);
        }
    }

    public void addCellError(ReportCellError error) {
        if (this.errorSheetAdded.get()) {
            throw new IllegalStateException("Error sheet already added, too late to submit new errors");
        }
        this.cellErrors.add(error);
    }

    public void addSheetError(ReportSheetError error) {
        if (this.errorSheetAdded.get()) {
            throw new IllegalStateException("Error sheet already added, too late to submit new errors");
        }
        this.sheetErrors.add(error);
    }

    public List<ReportCellError> getCellErrors() {
        return this.cellErrors;
    }

    public List<ReportSheetError> getSheetErrors() {
        return this.sheetErrors;
    }

    public ExcelStyles getStyles() {
        return this.styles;
    }
}

