/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl.filesystem;

import com.xebialabs.xlrelease.reports.job.api.ReportResult;
import com.xebialabs.xlrelease.reports.job.api.ReportStorage;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.impl.filesystem.FileSystemStreamingReportResult;
import com.xebialabs.xlrelease.reports.job.impl.filesystem.FileSystemStreamingReportStorage;
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\u0006\f\u0001iA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006q\u0001!\t!\u000f\u0005\t{\u0001\u0011\r\u0011\"\u0001\u000e}!1q\t\u0001Q\u0001\n}BQ\u0001\u0013\u0001\u0005B%CQ!\u001c\u0001\u0005B9DQa\u001e\u0001\u0005\u0002aD\u0001\"!\u0003\u0001\t\u0003i\u00111\u0002\u0005\b\u0003#\u0001AQBA\n\u0005]1\u0015\u000e\\3TsN$X-\u001c*fa>\u0014Ho\u0015;pe\u0006<WM\u0003\u0002\r\u001b\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u00059y\u0011\u0001B5na2T!\u0001E\t\u0002\u0007)|'M\u0003\u0002\u0013'\u00059!/\u001a9peR\u001c(B\u0001\u000b\u0016\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M!\u0001aG\u0011(!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!%J\u0007\u0002G)\u0011AeD\u0001\u0004CBL\u0017B\u0001\u0014$\u00055\u0011V\r]8siN#xN]1hKB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006g24GG\u001b\u0006\u0002Y\u0005AqM]5{u2,G-\u0003\u0002/S\t9Aj\\4hS:<\u0017A\u00057pG\u0006d7\u000b^8sC\u001e,7i\u001c8gS\u001e\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u000b1|7-\u00197\u000b\u0005U\u001a\u0012aB:u_J\fw-Z\u0005\u0003oI\u0012!\u0003T8dC2\u001cFo\u001c:bO\u0016\u001cuN\u001c4jO\u00061A(\u001b8jiz\"\"A\u000f\u001f\u0011\u0005m\u0002Q\"A\u0006\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\u001bI|w\u000e\u001e*fa>\u0014H\u000fR5s+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\tIwNC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%\u0001\u0002$jY\u0016\faB]8piJ+\u0007o\u001c:u\t&\u0014\b%A\u0007sKB|'\u000f^*u_J\fw-\u001a\u000b\u0004\u00156+\u0007CA\u001eL\u0013\ta5B\u0001\u0011GS2,7+_:uK6\u001cFO]3b[&twMU3q_J$8\u000b^8sC\u001e,\u0007\"\u0002(\u0006\u0001\u0004y\u0015!\u00026pE&#\u0007C\u0001)c\u001d\t\t\u0006M\u0004\u0002S?:\u00111K\u0018\b\u0003)vs!!\u0016/\u000f\u0005Y[fBA,[\u001b\u0005A&BA-\u001a\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003%MI!\u0001E\t\n\u0005\u0011z\u0011BA1$\u0003Y\u0011V\r]8si&tw-\u00128hS:,7+\u001a:wS\u000e,\u0017BA2e\u0005-\u0011V\r]8si*{'-\u00133\u000b\u0005\u0005\u001c\u0003\"\u00024\u0006\u0001\u00049\u0017aC4f]\u0016\u0014\u0018\r^3e\u001f:\u0004\"\u0001[6\u000e\u0003%T!A[\"\u0002\tU$\u0018\u000e\\\u0005\u0003Y&\u0014A\u0001R1uK\u00069!/Z:pYZ,GCA8s!\t\u0011\u0003/\u0003\u0002rG\t)2\u000b\u001e:fC6Lgn\u001a*fa>\u0014HOU3tk2$\b\"B:\u0007\u0001\u0004!\u0018\u0001\u0004:fa>\u0014HOU3tk2$\bC\u0001\u0012v\u0013\t18E\u0001\u0007SKB|'\u000f\u001e*fgVdG/A\u0004dY\u0016\fg.\u001e9\u0015\u0005ed\bC\u0001\u000f{\u0013\tYXDA\u0004C_>dW-\u00198\t\u000bu<\u0001\u0019\u0001@\u0002\u0013I,\u0007o\u001c:u\u0015>\u0014\u0007cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002\b\u0005\u0005!!\u0003*fa>\u0014HOS8c\u0003I9W\r\u001e*fa>\u0014H\u000fR5sK\u000e$xN]=\u0015\u000b}\ni!a\u0004\t\u000b9C\u0001\u0019A(\t\u000b\u0019D\u0001\u0019A4\u0002)\u0011,G.\u001a;f!\u0006\u0014XM\u001c;t\u0013\u001a,U\u000e\u001d;z)\u0011\t)\"a\u0007\u0011\u0007q\t9\"C\u0002\u0002\u001au\u0011A!\u00168ji\"1\u0011QD\u0005A\u0002}\n1\u0001Z5sQ\rI\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0015\"a\u0002;bS2\u0014Xm\u0019")
public class FileSystemReportStorage
implements ReportStorage,
Logging {
    private final LocalStorageConfig localStorageConfig;
    private final File rootReportDir;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FileSystemReportStorage fileSystemReportStorage = this;
        synchronized (fileSystemReportStorage) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public File rootReportDir() {
        return this.rootReportDir;
    }

    @Override
    public FileSystemStreamingReportStorage reportStorage(Integer jobId, Date generatedOn) {
        File reportWorkdir = this.getReportDirectory(jobId, generatedOn);
        if (!reportWorkdir.exists()) {
            boolean bl;
            try {
                bl = reportWorkdir.mkdirs();
            }
            catch (Exception e) {
                String msg = "Unable to create directory for report job '" + jobId + "' in '" + this.rootReportDir() + "'.";
                throw new IllegalStateException(msg, e);
            }
            boolean isCreated = bl;
            if (!isCreated) {
                throw new IllegalStateException("Unable to create directory for report job '" + jobId + "' in '" + this.rootReportDir() + "'.");
            }
        }
        this.logger().debug((Function0 & Serializable)() -> "Created root directory for reports at '" + reportWorkdir.getAbsolutePath() + "' based on provided location '" + this.rootReportDir() + "'");
        return new FileSystemStreamingReportStorage(reportWorkdir, reportWorkdir);
    }

    @Override
    public StreamingReportResult resolve(ReportResult reportResult) {
        ReportResult reportResult2 = reportResult;
        if (reportResult2 instanceof StreamingReportResult) {
            StreamingReportResult streamingReportResult = (StreamingReportResult)reportResult2;
            return streamingReportResult;
        }
        FileSystemStreamingReportStorage jobStorage = this.reportStorage(reportResult.jobId(), reportResult.generatedOn());
        File jobDir = jobStorage.reportDir();
        if (!jobDir.exists()) {
            throw new IllegalStateException("Report directory of job '" + reportResult.jobId() + "' does not exist.");
        }
        return new FileSystemStreamingReportResult(jobDir.toURI(), reportResult);
    }

    @Override
    public boolean cleanup(ReportJob reportJob) {
        boolean bl;
        try {
            File jobDir = this.getReportDirectory(reportJob.getJobId(), reportJob.getEndTime());
            if (jobDir.exists()) {
                this.logger().debug((Function0 & Serializable)() -> "Deleting directory: " + jobDir.getPath());
                FileUtils.deleteDirectory((File)jobDir);
            }
            try {
                this.deleteParentsIfEmpty(jobDir);
            }
            catch (Throwable t) {
                this.logger().warn((Function0 & Serializable)() -> "Exception while deleting report's parent directory: " + t.toString(), (Function0 & Serializable)() -> t);
            }
            bl = true;
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Exception while deleting report's job directory: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public File getReportDirectory(Integer jobId, Date generatedOn) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        String dateFragment = formatter.format(generatedOn);
        File reportWorkdir = new File(this.rootReportDir(), dateFragment + "/" + jobId);
        return reportWorkdir;
    }

    private final void deleteParentsIfEmpty(File dir) {
        File parent;
        while (!(parent = dir.getParentFile()).equals(this.rootReportDir()) && parent.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])parent.list()))) {
            this.logger().trace((Function0 & Serializable)() -> "Deleting directory: " + parent.getPath());
            FileUtils.deleteDirectory((File)parent);
            dir = parent;
        }
    }

    public FileSystemReportStorage(LocalStorageConfig localStorageConfig) {
        this.localStorageConfig = localStorageConfig;
        Logging.$init$((Logging)this);
        this.rootReportDir = localStorageConfig.basePath().toFile();
        if (!this.rootReportDir().exists()) {
            try {
                this.rootReportDir().mkdirs();
                this.logger().debug((Function0 & Serializable)() -> "Created root directory for reports at '" + this.rootReportDir().getAbsolutePath() + "' based on provided location '" + $this.localStorageConfig.basePath() + "'");
            }
            catch (Exception e) {
                String msg = "Unable to create root directory for reports '" + localStorageConfig.basePath() + "'.";
                throw new IllegalStateException(msg, e);
            }
        }
        if (!this.rootReportDir().isDirectory()) {
            String msg = "Report storage root directory location '" + localStorageConfig.basePath() + "' does not point to a directory.";
            throw new IllegalStateException(msg);
        }
    }
}

