/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.versioning.ascode.settings;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.utils.ScmUtils;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.HashMap;

public final class FolderVersioningSettingsUtil {
    public static final String ENCODED_SEPARATOR = "%2F";
    public static final String FOLDER_VERSIONING_ID_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/versioning";
    public static final String FOLDER_VERSIONING_YAML_FILENAME = "Releasefile.yaml";
    public static final String CATEGORY_INTERNAL = "internal";
    public static final String TEMPLATES_VERSIONING_YAML_FILENAME = "Templates.yaml";
    public static final String WORKFLOWS_VERSIONING_YAML_FILENAME = "Workflows.yaml";
    public static final String PATTERNS_VERSIONING_YAML_FILENAME = "Patterns.yaml";
    public static final String TRIGGERS_VERSIONING_YAML_FILENAME = "Triggers.yaml";
    public static final String VARIABLES_VERSIONING_YAML_FILENAME = "Variables.yaml";
    public static final String PERMISSIONS_VERSIONING_YAML_FILENAME = "Permissions.yaml";
    public static final String NOTIFICATIONS_VERSIONING_YAML_FILENAME = "Notifications.yaml";
    public static final String DASHBOARDS_VERSIONING_YAML_FILENAME = "Dashboards.yaml";
    public static final String CONNECTIONS_VERSIONING_YAML_FILENAME = "Connections.yaml";
    public static final String APPLICATIONS_VERSIONING_YAML_FILENAME = "Applications.yaml";
    public static final String ENVIRONMENTS_VERSIONING_YAML_FILENAME = "Environments.yaml";
    public static final String TEMPLATES_VERSIONING_YAML_FILENAME_PREFIX = "Template_";
    public static final String WORKFLOWS_VERSIONING_YAML_FILENAME_PREFIX = "Workflow_";
    public static final String PATTERNS_VERSIONING_YAML_FILENAME_PREFIX = "Pattern_";
    public static final String TRIGGERS_VERSIONING_YAML_FILENAME_PREFIX = "Trigger_";
    public static final String DASHBOARDS_VERSIONING_YAML_FILENAME_PREFIX = "Dashboard_";

    private FolderVersioningSettingsUtil() {
    }

    public static String getDefinitionsPath(String scmPath) {
        return FolderVersioningSettingsUtil.getDefinitionsPath(scmPath, FOLDER_VERSIONING_YAML_FILENAME);
    }

    public static String getDefinitionsPath(String scmPath, String filename) {
        String normalized = ScmUtils.normalize(scmPath);
        String joined = normalized + "/" + filename;
        return joined.replaceAll("/+", "/");
    }

    public static String getfilename(String filepath) {
        return Ids.getName((String)filepath);
    }

    public static String generateTagName(String prefix, String version) throws ScmException {
        return FolderVersioningSettingsUtil.generateTagName(prefix, version, "${prefix}/${version}");
    }

    public static String generateTagName(String prefix, String version, String format) throws ScmException {
        if (version.isBlank()) {
            throw new ScmException(String.format("Unable to generate tag with config: prefix=[%s] version=[%s] format=[%s]", prefix, version, format), null, 500);
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("${prefix}", prefix);
        vars.put("${version}", version);
        String tag = VariableHelper.replaceAll(format, vars).strip();
        if (tag.startsWith("/")) {
            tag = tag.substring(1);
        }
        if (tag.endsWith("/")) {
            tag = tag.substring(0, tag.length() - 1);
        }
        if (tag.isEmpty()) {
            throw new ScmException("Unable to generate tag from configured scmPath", null, 500);
        }
        return tag;
    }
}

