/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GlobalContextRegistry;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;

public class ExtendByPropertyDescriptor
extends LocalPropertyDescriptor {
    private LocalPropertyDescriptor superPropertyDescriptor;

    public ExtendByPropertyDescriptor(DescriptorRegistryId typeSource, LocalPropertyDescriptor base, LocalPropertyDescriptor superPropertyDescriptor) {
        super(typeSource);
        this.setDeclaringDescriptor(base.getDeclaringDescriptor());
        this.setFromPropertyDescriptor(base);
        this.extendWith(superPropertyDescriptor);
        this.addDefaultValidationRules();
        this.superPropertyDescriptor = superPropertyDescriptor;
        this.registerDefault(GlobalContextRegistry.lookup(base));
    }

    private void extendWith(LocalPropertyDescriptor superDescriptor) {
        CheckUtils.checkArgument(superDescriptor.getKind() == this.getKind(), "Type '%s' attempts to overrides property '%s' declared in type '%s', but kind attribute does not match. Derived kind: '%s'. Super kind: '%s'.", this.getDeclaringDescriptor().getType(), this.getName(), superDescriptor.getDeclaringDescriptor().getType(), this.getKind(), superDescriptor.getKind());
        this.checkOverrideArgument(superDescriptor.getReferencedType() == null && this.getReferencedType() == null || superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().equals((Object)this.getReferencedType()) || superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().isSuperTypeOf(this.getReferencedType()), "referenceType", String.valueOf(superDescriptor.getReferencedType()) + " or a subtype thereof", superDescriptor);
        this.checkOverrideArgument(superDescriptor.getEnumClass() == this.getEnumClass(), "enumClass", superDescriptor.getEnumClass(), superDescriptor);
        this.setAsContainment(superDescriptor.isAsContainment());
        this.setNested(superDescriptor.isNested());
        if (!this.isPassword() && superDescriptor.isPassword()) {
            this.logger.warn("Type extension for {} does not define property {} as password, but super-type {} does.", new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), superDescriptor.getDeclaringDescriptor().getType()});
            this.setPassword(true);
        }
        this.setCandidateValuesFilter(superDescriptor.getCandidateValuesFilter());
        if (!this.isRequired()) {
            this.setRequired(superDescriptor.isRequired());
        }
        if (superDescriptor.isInspectionProperty()) {
            this.setInspectionProperty(true);
            this.setRequiredForInspection(superDescriptor.isRequiredForInspection());
        }
        if (this.getDescription().equals(this.getLabel())) {
            this.setDescription(superDescriptor.getDescription());
        }
        if (this.getLabel().equals(Strings.deCamelize(this.getName()))) {
            this.setLabel(superDescriptor.getLabel());
        }
        if (this.getCategory().equals("Common")) {
            this.setCategory(superDescriptor.getCategory());
        }
        if (this.getSize() == Property.Size.DEFAULT) {
            this.setSize(superDescriptor.getSize());
        }
        this.setDeployedSpecific(superDescriptor.isDeployedSpecific());
        if (this.getInputHint() == null) {
            this.setInputHint(InputHint.newInputHintFrom((InputHint)superDescriptor.getInputHint()));
        }
        if (this.getOrder() == 0) {
            this.setOrder(superDescriptor.getOrder());
        }
    }

    private void checkOverrideArgument(boolean condition, String attribute, Object expectedValue, PropertyDescriptor superDescriptor) {
        String attributeErrorTemplate = "Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.";
        CheckUtils.checkArgument(condition, "Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.", this.getDeclaringDescriptor().getType(), this.getName(), ((LocalPropertyDescriptor)superDescriptor).getDeclaringDescriptor().getType(), attribute, expectedValue);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.superPropertyDescriptor.set(item, value);
    }

    public Object get(ConfigurationItem item) {
        return this.superPropertyDescriptor.get(item);
    }

    public LocalPropertyDescriptor getSuperPropertyDescriptor() {
        return this.superPropertyDescriptor;
    }
}

