/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.deployit.plugin.api.reflect.CreatorDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LocalCreatorDescriptor
implements CreatorDescriptor {
    private String name;
    private String delegate;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Descriptor descriptor;

    private LocalCreatorDescriptor(Descriptor descriptor, String name) {
        this.name = name;
        this.descriptor = descriptor;
    }

    private LocalCreatorDescriptor(Descriptor descriptor, Method method) {
        this.name = method.getName();
        this.delegate = "methodInvoker";
        this.descriptor = descriptor;
    }

    LocalCreatorDescriptor(LocalCreatorDescriptor copyOf, Descriptor newOwner) {
        this.attributes = copyOf.attributes;
        this.delegate = copyOf.delegate;
        this.descriptor = newOwner;
    }

    static CreatorDescriptor from(Descriptor descriptor, Method method) {
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor(descriptor, method);
        LocalCreatorDescriptor.initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    public static CreatorDescriptor from(LocalDescriptor descriptor, String delegate, Map<String, String> attributes) {
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor((Descriptor)descriptor, delegate);
        creatorDescriptor.delegate = delegate;
        creatorDescriptor.attributes = attributes;
        LocalCreatorDescriptor.initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    private static void initVerifications(LocalCreatorDescriptor creatorDescriptor) {
        CheckUtils.checkNotNull(DelegateRegistry.getDelegate(creatorDescriptor.delegate, Delegate.Use.CREATOR), creatorDescriptor.delegate + " is referenced, but not registered.", new Object[0]);
    }

    void verify(Verifications verifications) {
        verifications.verify(this.descriptor.getType(), DelegateRegistry.exists(this.delegate, Delegate.Use.CREATOR), "No delegate called [%s] available for creator [%s]", this.delegate, this.getFqn());
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void invoke(CreatorContext context) {
        this.invokeDelegate(context);
    }

    private void invokeDelegate(CreatorContext context) {
        Method method = DelegateRegistry.getDelegate(this.delegate, Delegate.Use.CREATOR);
        try {
            if (method.getParameterCount() == 2) {
                method.invoke(null, context, this.attributes);
            } else {
                method.invoke(null, context);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.delegate + " on " + String.valueOf(context.getThisCI()));
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.delegate + " on " + String.valueOf(context.getThisCI()));
        }
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }
}

