/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.service;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageScheme;
import com.xebialabs.xlrelease.storage.service.StorageService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u0007\u000e\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tg\u0001\u0011)\u0019!C!i!A\u0001\t\u0001B\u0001B\u0003%Q\u0007C\u0003B\u0001\u0011\u0005!\tC\u0003G\u0001\u0011%q\tC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003`\u0001\u0011\u0005\u0003\rC\u0003m\u0001\u0011\u0005S\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\u0003+\u0011+g-Y;miN#xN]1hKN+'O^5dK*\u0011abD\u0001\bg\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0004ti>\u0014\u0018mZ3\u000b\u0005I\u0019\u0012!\u0003=me\u0016dW-Y:f\u0015\t!R#A\u0005yK\nL\u0017\r\\1cg*\ta#A\u0002d_6\u001c\u0001a\u0005\u0003\u00013}\u0019\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\tQ\"\u0003\u0002#\u001b\tq1\u000b^8sC\u001e,7+\u001a:wS\u000e,\u0007C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0013\u0001C4sSjTH.\u001a3\n\u0005)*#a\u0002'pO\u001eLgnZ\u0001\tgR|'/Y4fgB\u0019!$L\u0018\n\u00059Z\"!B!se\u0006L\bC\u0001\u00192\u001b\u0005y\u0011B\u0001\u001a\u0010\u0005\u001d\u0019Fo\u001c:bO\u0016\f!\u0003Z3gCVdGo\u0015;pe\u0006<W\rV=qKV\tQ\u0007\u0005\u00027{9\u0011qg\u000f\t\u0003qmi\u0011!\u000f\u0006\u0003u]\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qZ\u0012a\u00053fM\u0006,H\u000e^*u_J\fw-\u001a+za\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002D\t\u0016\u0003\"\u0001\t\u0001\t\u000b-\"\u0001\u0019\u0001\u0017\t\u000bM\"\u0001\u0019A\u001b\u0002\u0015\u001d,Go\u0015;pe\u0006<W\r\u0006\u00020\u0011\")\u0011*\u0002a\u0001\u0015\u0006i1\u000f^8sC\u001e,7k\u00195f[\u0016\u0004\"a\u0013(\u000e\u00031S!!T\b\u0002\r\u0011|W.Y5o\u0013\tyEJA\u0007Ti>\u0014\u0018mZ3TG\",W.Z\u0001\u0006gR|'/\u001a\u000b\u0003%j\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u00079,GOC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&aA+S\u0013\")1L\u0002a\u00019\u0006a1\u000f^8sC\u001e,WI\u001c;ssB\u00111*X\u0005\u0003=2\u0013Ab\u0015;pe\u0006<W-\u00128uef\f1aZ3u)\t\tw\r\u0005\u0002cK6\t1M\u0003\u0002e-\u0006\u0011\u0011n\\\u0005\u0003M\u000e\u00141\"\u00138qkR\u001cFO]3b[\")\u0001n\u0002a\u0001S\u0006y1\u000f^8sC\u001e,WI\u001c;ssJ+g\r\u0005\u0002LU&\u00111\u000e\u0014\u0002\u0010'R|'/Y4f\u000b:$(/\u001f*fM\u0006yA.[:u\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0002ooB\u0019q\u000e\u001e*\u000f\u0005A\u0014hB\u0001\u001dr\u0013\u0005a\u0012BA:\u001c\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\t1K7\u000f\u001e\u0006\u0003gnAQ\u0001\u001b\u0005A\u0002%\f\u0011\u0002\\5ti\u001aKG.Z:\u0015\u00059T\b\"\u00025\n\u0001\u0004I\u0017A\u00023fY\u0016$X\rF\u0002~\u0003\u0003\u0001\"A\u0007@\n\u0005}\\\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006Q*\u0001\r![\u0001\u000eI\u0016dW\r^3JM\u0016k\u0007\u000f^=\u0015\u0007u\f9\u0001C\u0003i\u0017\u0001\u0007\u0011\u000e")
public class DefaultStorageService
implements StorageService,
Logging {
    private final Storage[] storages;
    private final String defaultStorageType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultStorageService defaultStorageService = this;
        synchronized (defaultStorageService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String defaultStorageType() {
        return this.defaultStorageType;
    }

    private Storage getStorage(StorageScheme storageScheme) {
        String string;
        Option<String> option = storageScheme.uriScheme();
        if (option instanceof Some) {
            String uriScheme;
            Some some = (Some)option;
            string = uriScheme = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = this.defaultStorageType();
        } else {
            throw new MatchError(option);
        }
        String uriScheme = string;
        return (Storage)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.storages), (Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DefaultStorageService.$anonfun$getStorage$1(uriScheme, s))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unable to find storage for entry " + uriScheme);
        });
    }

    @Override
    public URI store(StorageEntry storageEntry) {
        Storage storage = this.getStorage(storageEntry);
        URI entryUri = new URI(storage.uriScheme(), null, storageEntry.uriPath(), null);
        this.logger().trace((Function0 & Serializable)() -> "Storing log entry: " + storageEntry + " with uri " + entryUri);
        return (URI)Using$.MODULE$.apply((Function0 & Serializable)() -> storageEntry.content(), (Function1 & Serializable)is -> {
            URI storedUri = storage.put(entryUri, (InputStream)is);
            return storedUri;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).recoverWith((PartialFunction)new Serializable(null, storageEntry, entryUri){
            private static final long serialVersionUID = 0L;
            private final StorageEntry storageEntry$1;
            private final URI entryUri$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new RuntimeException("Unable to store log entry " + this.storageEntry$1 + " with uri " + this.entryUri$1, A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.storageEntry$1 = storageEntry$1;
                this.entryUri$1 = entryUri$1;
            }
        }).get();
    }

    @Override
    public InputStream get(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.get(storageEntryRef.uri());
    }

    @Override
    public List<URI> listDirectories(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.listDirectories(storageEntryRef.uri());
    }

    @Override
    public List<URI> listFiles(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.listFiles(storageEntryRef.uri());
    }

    @Override
    public boolean delete(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.delete(storageEntryRef.uri());
    }

    @Override
    public boolean deleteIfEmpty(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.deleteIfEmpty(storageEntryRef.uri());
    }

    public static final /* synthetic */ boolean $anonfun$getStorage$1(String uriScheme$1, Storage s) {
        String string = s.uriScheme();
        String string2 = uriScheme$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DefaultStorageService(Storage[] storages, String defaultStorageType) {
        this.storages = storages;
        this.defaultStorageType = defaultStorageType;
        Logging.$init$((Logging)this);
    }
}

