/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualThreadFactory;
import org.jboss.resteasy.concurrent.SecurityActions;

class GlobalContextualExecutorService
extends ContextualExecutorService {
    static final GlobalContextualExecutorService INSTANCE = new GlobalContextualExecutorService();
    private final Thread shutdownHook;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ExecutorService delegate;

    private GlobalContextualExecutorService() {
        super(null, true);
        int poolSize = SecurityActions.getCoreThreads("dev.resteasy.concurrent.core.pool.size");
        this.delegate = new ThreadPoolExecutor(poolSize, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ContextualThreadFactory("contextual-pool"));
        this.shutdownHook = new Thread("resteasy-shutdown"){

            @Override
            public void run() {
                if (GlobalContextualExecutorService.this.shutdown.compareAndSet(false, true)) {
                    GlobalContextualExecutorService.this.delegate.shutdownNow();
                }
            }
        };
        SecurityActions.registerShutdownHook(this.shutdownHook);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    ExecutorService getDelegate() {
        return this.delegate;
    }
}

