import React from 'react';
import { DotAutoComplete } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { FilterAutocomplete, FilterAutocompleteProps } from './filter-autocomplete.component';

describe('FilterAutocomplete', () => {
    const onChange = jest.fn();
    const className = 'my-class';

    const defaultProps: FilterAutocompleteProps = {
        className,
        inputId: 'my-id',
        onChange,
        options: [
            { id: '1', title: 'one' },
            { id: '2', title: 'two' },
        ],
        placeholder: 'my placeholder',
        value: [{ id: '1', title: 'one' }],
    };

    let wrapper: ReactWrapper;

    const mount = (props: FilterAutocompleteProps = defaultProps) => {
        wrapper = mountWithTheme(<FilterAutocomplete {...props} />);
    };

    const getAutocomplete = () => wrapper.find(DotAutoComplete);

    it('should have default props', () => {
        mount();
        const autocompleteProps = getAutocomplete().props();
        expect(autocompleteProps.className).toStrictEqual(className);
        expect(autocompleteProps.freesolo).toStrictEqual(false);
        expect(autocompleteProps.inputId).toStrictEqual(defaultProps.inputId);
        expect(autocompleteProps.multiple).toStrictEqual(true);
        expect(autocompleteProps.options).toStrictEqual(defaultProps.options);
        expect(autocompleteProps.placeholder).toStrictEqual(defaultProps.placeholder);
        expect(autocompleteProps.value).toStrictEqual(defaultProps.value);
    });

    it('should call onChange with selected ids', () => {
        mount();
        getAutocomplete().invoke('onChange')?.(null, [{ id: '2', title: 'two' }]);
        expect(onChange).toHaveBeenCalledWith(['2']);
    });
});
