import React from 'react';
import { TaskAttributeProps } from '@xlr-ui/app/features/tasks/components/rails/attributes/types';
import { useAppSelector } from '@xlr-ui/app/js/hooks';

import { deploymentTaskFacet, DeploymentTaskFacetState, getDeploymentTaskFacetState } from '../../ducks/deployment-task-facet.reducer';
import { DeploymentTaskFacetCommon } from './deployment-task-facet-common.component';

const { loadEnvironments } = deploymentTaskFacet.actions;

export const DeploymentTaskFacetEnvironment = ({ disabled, facet, property, onChange, onNewVariable }: TaskAttributeProps) => {
    const { environments }: DeploymentTaskFacetState = useAppSelector(getDeploymentTaskFacetState);

    return (
        <DeploymentTaskFacetCommon
            disabled={disabled}
            facet={facet}
            onChange={onChange}
            onInit={loadEnvironments}
            onNewVariable={onNewVariable}
            options={environments}
            property={property}
        />
    );
};
