import React from 'react';
import { Provider } from 'react-redux';
import { mountWithTheme } from '@xlr-ui/tests/unit/testing-utils';
import { store } from '@xlr-ui/app/js/app-config';
import { WorkflowTileContainer } from './workflow-tile.container';
import { WorkflowTile, WorkflowTileProps } from './workflow-tile.component';
import { DotThemeProvider } from '@digital-ai/dot-components';

describe('WorkflowTileContainer', () => {
    it('should render WorkflowTile wrapped into correct providers and with correct props', () => {
        const props: WorkflowTileProps = {
            description: 'my description',
            title: 'tile1',
        };

        const wrapper = mountWithTheme(<WorkflowTileContainer {...props} />);
        const dotThemeProvider = wrapper.find(DotThemeProvider);
        expect(dotThemeProvider).toExist();
        const provider = wrapper.find(Provider);
        expect(provider.props().store).toStrictEqual(store);
        const workflowTile = wrapper.find(WorkflowTile);
        expect(workflowTile).toExist();
        expect(workflowTile.props()).toStrictEqual(props);
    });
});
