import { RootState } from '@xlr-ui/app/js/store.types';
import { Application, ApplicationForm, ApplicationList, Environment, Stage } from '../../../application-list.types';

export const getApplicationListState = (state: RootState): ApplicationList => state.applicationList;
export const getApplicationFormState = (state: RootState): ApplicationForm => state.applicationForm;

export const getApplicationsSelector = (state: RootState): Array<Application> => getApplicationListState(state).applications;
export const getDeleteModalIsOpen = (state: RootState): boolean => getApplicationListState(state).deleteModalIsOpen;

export const getApplicationForDelete = (state: RootState): Application => getApplicationListState(state).applicationToDelete;

export const getFormApplication = (state: RootState): Application => getApplicationFormState(state).application;

export const getFormApplications = (state: RootState): Array<Application> => getApplicationFormState(state).applications;

export const getFormEnvironments = (state: RootState): Array<Environment> => getApplicationFormState(state).environments;

export const getFormStages = (state: RootState): Array<Stage> => getApplicationFormState(state).stages;
