import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { AnalyticsCategoriesSkeleton } from './analytics-categories.skeleton';

describe('AnalyticsCategoriesSkeleton', () => {
    let wrapper: ReactWrapper;

    const getCheckboxSkeletonDivs = () => wrapper.find('div.checkbox-skeleton');

    beforeEach(() => {
        wrapper = mountWithTheme(<AnalyticsCategoriesSkeleton />);
    });

    it('should create 5 cards with 2 skeletons in each', () => {
        const checkboxSkeletonDivs = getCheckboxSkeletonDivs();
        expect(checkboxSkeletonDivs).toHaveLength(5);
        checkboxSkeletonDivs.forEach((checkboxSkeletonDiv) => {
            const dotSkeletons = checkboxSkeletonDiv.find(DotSkeleton);
            expect(dotSkeletons.length).toBe(2);
            const dotSkeletonOneProps = dotSkeletons.at(0).props();
            expect(dotSkeletonOneProps.height).toBe('35px');
            expect(dotSkeletonOneProps.variant).toBe('text');
            expect(dotSkeletonOneProps.width).toBe(25);

            const dotSkeletonTwoProps = dotSkeletons.at(1).props();
            expect(dotSkeletonTwoProps.height).toBe('35px');
            expect(dotSkeletonTwoProps.variant).toBe('text');
            expect(dotSkeletonTwoProps.width).toBe('100%');
        });
    });
});
