/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PythonScriptDefinition
extends TaskDefinition {
    private static final String CATEGORY_TRANSITIONAL = "script";
    private static final Predicate<PropertyDescriptor> IS_INPUT_PROPERTY = PythonScriptDefinition.byCategory("input").and(PythonScriptDefinition.ofKind(PropertyKind.STRING).or(PythonScriptDefinition.notAPassword().and(PythonScriptDefinition.ofKind(PropertyKind.BOOLEAN, PropertyKind.INTEGER, PropertyKind.LIST_OF_STRING, PropertyKind.SET_OF_STRING, PropertyKind.MAP_STRING_STRING, PropertyKind.CI, PropertyKind.ENUM, PropertyKind.DATE))));
    private static final Predicate<PropertyDescriptor> IS_TRANSITIONAL_OR_OUTPUT_PROPERTY = PythonScriptDefinition.isVisible().and(PythonScriptDefinition.ofKind(PropertyKind.STRING).or(PythonScriptDefinition.notAPassword().and(PythonScriptDefinition.ofKind(PropertyKind.BOOLEAN, PropertyKind.INTEGER, PropertyKind.LIST_OF_STRING, PropertyKind.SET_OF_STRING, PropertyKind.MAP_STRING_STRING, PropertyKind.DATE))));
    private static final Predicate<PropertyDescriptor> IS_OUTPUT_PROPERTY = PythonScriptDefinition.byCategory("output").and(IS_TRANSITIONAL_OR_OUTPUT_PROPERTY);
    private static final Predicate<PropertyDescriptor> IS_TRANSITIONAL_PROPERTY = PythonScriptDefinition.byCategory("script").and(IS_TRANSITIONAL_OR_OUTPUT_PROPERTY);
    private Collection<PropertyDescriptor> inputProperties;
    private Collection<PropertyDescriptor> outputProperties;
    private Collection<PropertyDescriptor> transitionalProperties;

    public PythonScriptDefinition(Type type, boolean allowed) {
        super(type, allowed);
        Preconditions.checkArgument((boolean)type.getDescriptor().isAssignableTo(PythonScript.class), (String)"The type %s must extend xlrelease.PythonScript", (Object[])new Object[]{type.getDescriptor().getType()});
        Collection properties = type.getDescriptor().getPropertyDescriptors();
        this.inputProperties = properties.stream().filter(IS_INPUT_PROPERTY).collect(Collectors.toList());
        this.outputProperties = properties.stream().filter(IS_OUTPUT_PROPERTY).collect(Collectors.toList());
        this.transitionalProperties = properties.stream().filter(IS_TRANSITIONAL_PROPERTY).collect(Collectors.toList());
    }

    public PythonScriptDefinition(Type type) {
        this(type, true);
    }

    public Collection<PropertyDescriptor> getInputProperties() {
        return this.inputProperties;
    }

    public Collection<PropertyDescriptor> getOutputProperties() {
        return this.outputProperties;
    }

    Collection<PropertyDescriptor> getTransitionalProperties() {
        return this.transitionalProperties;
    }

    Collection<PropertyDescriptor> getTransitionalAndOutputProperties() {
        return Stream.concat(this.transitionalProperties.stream(), this.outputProperties.stream()).collect(Collectors.toList());
    }

    public static boolean isScriptDefinition(Type type) {
        return type.getDescriptor().isAssignableTo(PythonScript.class);
    }

    public static Predicate<PropertyDescriptor> ofKind(PropertyKind ... propertyKinds) {
        return input -> Arrays.asList(propertyKinds).contains(input.getKind());
    }

    private static Predicate<PropertyDescriptor> notAPassword() {
        return input -> !input.isPassword();
    }

    private static Predicate<PropertyDescriptor> byCategory(String category) {
        return property -> category.equals(property.getCategory());
    }

    private static Predicate<PropertyDescriptor> isVisible() {
        return input -> !input.isHidden();
    }
}

