/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;
import liquibase.util.StringUtils;

@DataTypeInfo(name="clob", aliases={"longvarchar", "text", "longtext", "java.sql.Types.LONGVARCHAR", "java.sql.Types.CLOB", "nclob", "longnvarchar", "ntext", "java.sql.Types.LONGNVARCHAR", "java.sql.Types.NCLOB", "tinytext", "mediumtext"}, minParameters=0, maxParameters=0, priority=1)
public class ClobType
extends LiquibaseDataType {
    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return value.toString();
        }
        String val = String.valueOf(value);
        if (val.startsWith("'")) {
            return val;
        }
        if (database instanceof MSSQLDatabase && !StringUtils.isAscii(val)) {
            return "N'" + database.escapeStringForDatabase(val) + "'";
        }
        return "'" + database.escapeStringForDatabase(val) + "'";
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition = StringUtils.trimToEmpty(this.getRawDefinition());
        if (database instanceof MSSQLDatabase && !LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "convertDataTypes").getValue(Boolean.class).booleanValue() && originalDefinition.toLowerCase().startsWith("text")) {
            return new DatabaseDataType("TEXT");
        }
        if (database instanceof FirebirdDatabase) {
            return new DatabaseDataType("BLOB SUB_TYPE TEXT");
        }
        if (database instanceof SybaseASADatabase) {
            return new DatabaseDataType("LONG VARCHAR");
        }
        if (database instanceof MSSQLDatabase) {
            if (originalDefinition.equalsIgnoreCase("text") || originalDefinition.equals("[text]") || originalDefinition.matches("(?i)text .+") || originalDefinition.matches("\\[text\\] .+")) {
                DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("text"));
                type.addAdditionalInformation(this.getAdditionalInformation());
                return type;
            }
            if (originalDefinition.equalsIgnoreCase("ntext") || originalDefinition.equals("[ntext]") || originalDefinition.matches("(?i)ntext .+") || originalDefinition.matches("\\[ntext\\] .+")) {
                DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("ntext"));
                type.addAdditionalInformation(this.getAdditionalInformation());
                return type;
            }
            if (originalDefinition.equalsIgnoreCase("nclob")) {
                try {
                    if (database.getDatabaseMajorVersion() <= 8) {
                        DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("ntext"));
                        type.addAdditionalInformation(this.getAdditionalInformation());
                        return type;
                    }
                }
                catch (DatabaseException ignore) {
                    // empty catch block
                }
                return new DatabaseDataType(database.escapeDataTypeName("nvarchar"), "MAX");
            }
            try {
                if (database.getDatabaseMajorVersion() <= 8) {
                    DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("text"));
                    type.addAdditionalInformation(this.getAdditionalInformation());
                    return type;
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            return new DatabaseDataType(database.escapeDataTypeName("varchar"), "MAX");
        }
        if (database instanceof MySQLDatabase) {
            if (originalDefinition.toLowerCase().startsWith("text")) {
                return new DatabaseDataType("TEXT");
            }
            if (originalDefinition.toLowerCase().startsWith("tinytext")) {
                return new DatabaseDataType("TINYTEXT");
            }
            if (originalDefinition.toLowerCase().startsWith("mediumtext")) {
                return new DatabaseDataType("MEDIUMTEXT");
            }
            return new DatabaseDataType("LONGTEXT");
        }
        if (database instanceof H2Database || database instanceof HsqlDatabase) {
            if (originalDefinition.toLowerCase().startsWith("longvarchar") || originalDefinition.startsWith("java.sql.Types.LONGVARCHAR")) {
                return new DatabaseDataType("LONGVARCHAR");
            }
            return new DatabaseDataType("CLOB");
        }
        if (database instanceof PostgresDatabase || database instanceof SQLiteDatabase || database instanceof SybaseDatabase) {
            return new DatabaseDataType("TEXT");
        }
        if (database instanceof OracleDatabase) {
            if (originalDefinition.equalsIgnoreCase("nclob")) {
                return new DatabaseDataType("NCLOB");
            }
            return new DatabaseDataType("CLOB");
        }
        if (database instanceof InformixDatabase && originalDefinition.toLowerCase().startsWith("text")) {
            return new DatabaseDataType("TEXT");
        }
        return super.toDatabaseDataType(database);
    }
}

