/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.DateTimeType;
import liquibase.util.StringUtils;

@DataTypeInfo(name="timestamp", aliases={"java.sql.Types.TIMESTAMP", "java.sql.Timestamp", "timestamptz"}, minParameters=0, maxParameters=1, priority=1)
public class TimestampType
extends DateTimeType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition = StringUtils.trimToEmpty(this.getRawDefinition());
        if (database instanceof MySQLDatabase) {
            if (this.getRawDefinition().contains(" ") || this.getRawDefinition().contains("(")) {
                return new DatabaseDataType(this.getRawDefinition());
            }
            return super.toDatabaseDataType(database);
        }
        if (database instanceof MSSQLDatabase) {
            if (!LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "convertDataTypes").getValue(Boolean.class).booleanValue() && originalDefinition.toLowerCase().startsWith("timestamp")) {
                return new DatabaseDataType(database.escapeDataTypeName("TIMESTAMP"));
            }
            return new DatabaseDataType(database.escapeDataTypeName("DATETIME"));
        }
        return super.toDatabaseDataType(database);
    }
}

