/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IgnoringMissingCIRepository
extends RepositoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(IgnoringMissingCIRepository.class);

    @Autowired
    public IgnoringMissingCIRepository(RepositoryService repositoryService, Validator validator) {
        super(repositoryService, validator, null);
    }

    public <T extends ConfigurationItem> T read(String id) {
        try {
            return (T)super.read(id);
        }
        catch (NotFoundException e) {
            logger.info(String.format("Could not find CI [%s], it was removed", id));
            return null;
        }
    }
}

